/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.PessoaAtualizador;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.PessoaDTO;
import br.com.elotech.protocolo.service.PessoaAtualizadorService;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pessoas"})
public class PessoaAtualizadorResource {
    private final PessoaAtualizadorService service;
    private final ProtocoloMapper mapper;

    public PessoaAtualizadorResource(PessoaAtualizadorService service, ProtocoloMapper mapper) {
        this.service = service;
        this.mapper = mapper;
    }

    @GetMapping(value={"/atualizacoes"})
    public ResponseEntity<List<PessoaAtualizador>> findAll() {
        return ResponseEntity.ok((Object)this.service.findAll());
    }

    @GetMapping(value={"/atualizacao/cpf/{cpfCnpj}"})
    public ResponseEntity<List<PessoaAtualizador>> findAllAtualizacoes(@PathVariable(name="cpfCnpj") String cpfCnpj) {
        return ResponseEntity.ok((Object)this.service.findAllAtualizacoesPessoa(cpfCnpj));
    }

    @PostMapping(value={"/atualizar/pessoa/{idPessoa}/atualizador/{idAtualizador}"})
    public ResponseEntity<PessoaDTO> atualizarPessoa(@PathVariable(name="idPessoa") Long idPessoa, @PathVariable(name="idAtualizador") Long idAtualizador) {
        PessoaAtualizador atualizador = (PessoaAtualizador)this.service.findOne(idAtualizador).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, String.format("Atualizador com id %s n\u00e3o encontrado.", idAtualizador)));
        Pessoa pessoa = (Pessoa)this.service.findOnePessoa(idPessoa).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, String.format("Pessoa com id %s n\u00e3o encontrado.", idPessoa)));
        return ResponseEntity.ok((Object)this.mapper.toPessoaDTO(this.service.atualizarPessoa(pessoa, atualizador, SecurityContextHolder.getContext().getAuthentication().getName())));
    }
}

