/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Parametro;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.ParametroDTO;
import br.com.elotech.protocolo.dto.ResponseParametroValidation;
import br.com.elotech.protocolo.service.ModuloService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.strategy.impl.parametro.ParametroValidatorFactory;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parametros"})
public class ParametroResource {
    private static final String NOT_FOUND_MESSAGE = "Registro n\u00e3o encontrado.";
    private final ParametroService service;
    private final ModuloService moduloService;
    private final ProtocoloMapper mapper;
    private final ParametroValidatorFactory parametroValidatorFactory;

    public ParametroResource(ParametroService service, ModuloService moduloService, ProtocoloMapper mapper, ParametroValidatorFactory parametroValidatorFactory) {
        this.service = service;
        this.mapper = mapper;
        this.moduloService = moduloService;
        this.parametroValidatorFactory = parametroValidatorFactory;
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ParametroDTO> findParametro(@PathVariable Long id, @RequestHeader(value="EXERCICIO") Long exercicio) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        return ResponseEntity.ok((Object)this.mapper.toParametroDTO((Parametro)this.service.findOneOrDefault(id, entidade.getId(), exercicio)));
    }

    @GetMapping(value={"/validar-grupo/{idGrupo}"})
    public ResponseEntity<ResponseParametroValidation> validGroup(@PathVariable Long idGrupo) {
        return ResponseEntity.ok((Object)this.parametroValidatorFactory.getParametroValidator(idGrupo).validar());
    }

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<ParametroDTO>> findParametros(@RequestHeader(value="EXERCICIO") Long exercicio) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        List lstParametro = this.service.findAllList(entidade, exercicio);
        List dto = lstParametro.stream().map(arg_0 -> ((ProtocoloMapper)this.mapper).toParametroDTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok().body(dto);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/update-lista"})
    public ResponseEntity<List<ParametroDTO>> updateLista(@RequestBody @Valid List<ParametroDTO> dto, Authentication authentication, @RequestHeader(value="EXERCICIO") Long exercicio) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        List parametrosAlterados = this.service.saveAll(dto.stream().map(arg_0 -> ((ProtocoloMapper)this.mapper).toParametro(arg_0)).collect(Collectors.toList()), entidade.getId(), exercicio);
        this.service.actionsParametrosAlterados(parametrosAlterados);
        return ResponseEntity.ok().body(dto);
    }
}

