/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.client.painel.dto.NotificationSearchDTO;
import br.com.elotech.client.painel.feign.NotificationFeign;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.lib.painel.dto.CountNotReaded;
import br.com.elotech.lib.painel.dto.DataNotificationDTO;
import br.com.elotech.lib.painel.dto.NotificationDTO;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notificacoes"})
public class NotificacaoResource {
    private final NotificationFeign notificationFeign;
    private final String webSocketURL;

    public NotificacaoResource(NotificationFeign notificationFeign, @Value(value="${elotech.websocketURL:}") String webSocketURL) {
        this.notificationFeign = notificationFeign;
        this.webSocketURL = webSocketURL;
    }

    @GetMapping
    public EloPage<NotificationSearchDTO> findAllBy(@RequestParam(name="search", required=false) String search, Pageable page) {
        return this.notificationFeign.findAllBy(search, page);
    }

    @GetMapping(value={"/count-not-readed"})
    public CountNotReaded countNotReaded() {
        return this.notificationFeign.countNotReaded();
    }

    @PostMapping
    public NotificationDTO publishMessage(@RequestBody DataNotificationDTO dataNotificationDTO) {
        return this.notificationFeign.publishMessage(dataNotificationDTO);
    }

    @PutMapping
    public void markReaded(@RequestBody List<UUID> uuids) {
        this.notificationFeign.markReaded(uuids);
    }

    @GetMapping(value={"/websocket-url"})
    public String getWebSocketURL() {
        return this.webSocketURL;
    }
}

