/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.adm.domain.dto.OfficeDTO;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.protocolo.domain.ModeloDados;
import br.com.elotech.protocolo.dto.ModeloParamsDTO;
import br.com.elotech.protocolo.service.ModeloDadosService;
import java.io.IOException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/modelos"})
public class ModeloDadosResource
extends ReadOnlyResource<ModeloDados, Long> {
    public ModeloDadosService getService() {
        return (ModeloDadosService)super.getService();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ModeloDados> findOne(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.getService().findOne(id));
    }

    @PostMapping
    public ResponseEntity<Long> save(@RequestBody ModeloDados modeloDados, Authentication auth) {
        return ResponseEntity.ok((Object)this.getService().saveOrUpdate(modeloDados, auth).getId());
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Long> update(@RequestBody ModeloDados modeloDados, Authentication auth) {
        return ResponseEntity.ok((Object)this.getService().saveOrUpdate(modeloDados, auth).getId());
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable(value="id") Long id) {
        this.getService().delete(id);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/preview"})
    public ResponseEntity<String> preview(@RequestBody ModeloParamsDTO params) throws IOException {
        return ResponseEntity.ok((Object)this.getService().processarModeloDados(params));
    }

    @PostMapping(value={"/{id}/clone"})
    public ResponseEntity<Long> clone(@PathVariable(value="id") Long id, @RequestBody ModeloDados modeloDados) {
        return ResponseEntity.ok((Object)this.getService().clone(id, modeloDados.getNome()).getId());
    }

    @GetMapping(value={"/{id}/template"})
    public ResponseEntity<String> findTemplate(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.getService().findTemplate(id));
    }

    @PostMapping(value={"/{id}/arquivo"})
    public ResponseEntity<Void> saveArquivo(@PathVariable(value="id") Long id, @RequestParam(value="arquivo") MultipartFile arquivo, Authentication auth) {
        this.getService().saveArquivo(id, arquivo, auth);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/preview-office"})
    public ResponseEntity<byte[]> previewOffice(@RequestBody ModeloParamsDTO params) {
        OfficeDTO officeDTO = this.getService().processarModeloDadosOffice(params);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", officeDTO.getMimeType().getType());
        return new ResponseEntity((Object)officeDTO.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }
}

