/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.core.web.rest.dto.DTOConverter;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.LocalPK;
import br.com.elotech.protocolo.domain.Roteiro;
import br.com.elotech.protocolo.dto.LocalDTO;
import br.com.elotech.protocolo.interfaces.ILocal;
import br.com.elotech.protocolo.service.LocalService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/locais"})
public class LocalResource
extends BaseResourceDTO<Local, LocalPK, LocalDTO> {
    public LocalService getService() {
        return (LocalService)super.getService();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<LocalDTO> findOne(@PathVariable Long id) {
        return super.findOne((Serializable)LocalPK.of((Entidade)RequestHeaderHelper.getEntidadeContextHolder(), (Long)id));
    }

    @GetMapping(value={"/usuario"})
    public ResponseEntity<Page<LocalDTO>> searchByUsuarioAndDescricao(@RequestParam(value="descricao", defaultValue="", required=false) String descricao, @RequestParam(value="local", defaultValue="", required=false) Long local, Pageable pageable) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Page page = this.getService().searchByUsuarioAndDescricao(authentication.getName(), descricao, local, pageable);
        return ResponseEntity.ok((Object)page.map(arg_0 -> ((DTOConverter)this.getConverter()).to(arg_0)));
    }

    @PostMapping
    public ResponseEntity<LocalDTO> save(@RequestBody @Valid LocalDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        return super.save((Object)dto, authentication, builder, request);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<LocalDTO> update(@RequestBody @Valid LocalDTO dto, @PathVariable Long id, Authentication authentication) {
        this.validarLocalPai(dto, dto.getLocalPai());
        return super.update((Object)dto, (Serializable)LocalPK.of((Entidade)RequestHeaderHelper.getEntidadeContextHolder(), (Long)id), authentication);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable Long id) {
        return super.remove((Serializable)LocalPK.of((Entidade)RequestHeaderHelper.getEntidadeContextHolder(), (Long)id));
    }

    @GetMapping(value={"/local-pai/{id}"})
    public ResponseEntity<List<LocalDTO>> findAllByLocalPai(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.findAllByLocalPaiId(id));
    }

    @GetMapping(value={"/{id}/roteiros"})
    public ResponseEntity<List<Roteiro>> getRoteirosByLocalId(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.getService().getRoteirosByLocalId(LocalPK.of((Entidade)RequestHeaderHelper.getEntidadeContextHolder(), (Long)id)));
    }

    private List<LocalDTO> findAllByLocalPaiId(Long id) {
        return this.getService().findAllByLocalPai(LocalPK.of((Entidade)RequestHeaderHelper.getEntidadeContextHolder(), (Long)id)).stream().map(arg_0 -> ((DTOConverter)this.getConverter()).to(arg_0)).sorted(Comparator.comparing(LocalDTO::getId)).collect(Collectors.toList());
    }

    private void validarLocalPai(LocalDTO dto, LocalDTO localPai) {
        if (Objects.nonNull(dto.getLocalPai()) && Objects.nonNull(localPai)) {
            List locais = this.findAllByLocalPaiId(dto.getId());
            for (LocalDTO local : locais) {
                if (local.getId().equals(dto.getLocalPai().getId()) || localPai.getId().equals(local.getId())) {
                    throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o \u00e9 poss\u00edvel atribuir este local pai, o mesmo j\u00e1 est\u00e1 vinculado como filho em alguma hierarquia.");
                }
                this.validarLocalPai(local, localPai);
            }
        }
    }

    @GetMapping(value={"/entidade/{entidade}"})
    public ResponseEntity<List<ILocal>> findByEntidadeSearch(@PathVariable(value="entidade") Long entidade, @RequestParam(value="search", required=false, defaultValue="") String search) {
        return ResponseEntity.ok((Object)this.getService().findByEntidadeSearch(entidade, search));
    }
}

