/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Gerencia;
import br.com.elotech.protocolo.domain.GerenciaPK;
import br.com.elotech.protocolo.dto.GerenciaDTO;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/gerencias"})
public class GerenciaResource
extends BaseResourceDTO<Gerencia, GerenciaPK, GerenciaDTO> {
    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    public ResponseEntity<GerenciaDTO> findOne(@PathVariable Long id) {
        Entidade entidade = new Entidade();
        entidade.setId(RequestHeaderHelper.getEntidadeLogada());
        GerenciaPK gerenciaPK = GerenciaPK.of((Entidade)entidade, (Long)id);
        return super.findOne((Serializable)gerenciaPK);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<GerenciaDTO> save(@RequestBody @Valid GerenciaDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        return super.save((Object)dto, authentication, builder, request);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    public ResponseEntity<GerenciaDTO> update(@RequestBody @Valid GerenciaDTO dto, @PathVariable Long id, Authentication authentication) {
        Entidade entidade = new Entidade();
        entidade.setId(RequestHeaderHelper.getEntidadeLogada());
        GerenciaPK gerenciaPK = GerenciaPK.of((Entidade)entidade, (Long)id);
        return super.update((Object)dto, (Serializable)gerenciaPK, authentication);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable Long id) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        GerenciaPK gerenciaPK = GerenciaPK.of((Entidade)entidade, (Long)id);
        return super.remove((Serializable)gerenciaPK);
    }
}

