/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.ExercicioDTO;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/exercicios"})
public class ExercicioResource {
    private final ExercicioService exercicioService;
    private final ProtocoloMapper mapper;

    public ExercicioResource(ExercicioService exercicioService, ProtocoloMapper mapper) {
        this.exercicioService = exercicioService;
        this.mapper = mapper;
    }

    @RequestMapping(value={"/padrao"}, method={RequestMethod.GET})
    public ResponseEntity<ExercicioDTO> getExercicioPadrao() {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        return Optional.ofNullable(this.exercicioService.getExercicioPadraoEntidade(entidade)).map(arg_0 -> ((ProtocoloMapper)this.mapper).toExercicioDTO(arg_0)).map(dto -> ResponseEntity.ok((Object)dto)).orElseThrow(() -> RestException.notFound((String)"N\u00e3o foi poss\u00edvel encontrar o exerc\u00edcio padr\u00e3o"));
    }
}

