/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.client.portal.EstatisticaPortalDTO;
import br.com.elotech.protocolo.client.portal.EstatisticaPortalParams;
import br.com.elotech.protocolo.client.portal.SerieItemDTO;
import br.com.elotech.protocolo.service.EstatisticaService;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/estatisticas"})
public class EstatisticaResource {
    private final EstatisticaService service;

    public EstatisticaResource(EstatisticaService service) {
        this.service = service;
    }

    @GetMapping
    public ResponseEntity<List<EstatisticaPortalDTO>> findEstatisticas(EstatisticaPortalParams params) {
        return ResponseEntity.ok((Object)this.service.findEstatisticas(params));
    }

    @GetMapping(value={"/media"})
    public ResponseEntity<BigDecimal> getMediaResposta(EstatisticaPortalParams params) {
        return ResponseEntity.ok((Object)this.service.getMediaResposta(params));
    }

    @GetMapping(value={"/processos-por-genero"})
    public ResponseEntity<List<SerieItemDTO>> findProcessosPorGenero(EstatisticaPortalParams params) {
        return ResponseEntity.ok((Object)this.service.findProcessosPorGenero(params));
    }

    @GetMapping(value={"/processos-por-idade"})
    public ResponseEntity<List<SerieItemDTO>> findProcessosPorIdade(EstatisticaPortalParams params) {
        return ResponseEntity.ok((Object)this.service.findProcessosPorIdade(params));
    }

    @GetMapping(value={"/processos-por-escolaridade"})
    public ResponseEntity<List<SerieItemDTO>> findProcessosPorEscolaridade(EstatisticaPortalParams params) {
        return ResponseEntity.ok((Object)this.service.findProcessosPorEscolaridade(params));
    }
}

