/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.EntidadeAutoCompleteDTO;
import br.com.elotech.protocolo.dto.EntidadeDTO;
import br.com.elotech.protocolo.dto.ExercicioDTO;
import br.com.elotech.protocolo.dto.UsuarioEntidadeDTO;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.UsuarioService;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/entidades"})
public class EntidadeResource {
    private final EntidadeService entidadeService;
    private final ExercicioService exercicioService;
    private final UsuarioService usuarioService;
    private final ProtocoloMapper mapper;

    public EntidadeResource(EntidadeService entidadeService, ExercicioService exercicioService, UsuarioService usuarioService, ProtocoloMapper mapper) {
        this.entidadeService = entidadeService;
        this.exercicioService = exercicioService;
        this.usuarioService = usuarioService;
        this.mapper = mapper;
    }

    @GetMapping
    public ResponseEntity<List<UsuarioEntidadeDTO>> findEntidadesUsuario() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        List entidades = this.usuarioService.findEntidadesByUsername(auth.getName());
        List dto = entidades.stream().map(arg_0 -> ((ProtocoloMapper)this.mapper).toUsuarioEntidadeDTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(dto);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<EntidadeDTO> findEntidadeById(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.mapper.toEntidadeDTO(this.getEntidadeOrThrowNotFound(id)));
    }

    @GetMapping(value={"/auto-complete"})
    public ResponseEntity<List<EntidadeAutoCompleteDTO>> findEntidadeAutoComplete(@RequestParam(value="search", defaultValue="", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok(this.entidadeService.findByRsql(search, pageable).stream().sorted(Comparator.comparing(Entidade::getId)).map(arg_0 -> ((ProtocoloMapper)this.mapper).toEntidadeAutoCompleteDTO(arg_0)).collect(Collectors.toList()));
    }

    @GetMapping(value={"/{id}/exercicios"})
    public ResponseEntity<List<ExercicioDTO>> getExerciciosByEntidade(@PathVariable(value="id") Long id) {
        Entidade entidade = this.getEntidadeOrThrowNotFound(id);
        List dto = this.exercicioService.findByEntidade(entidade).stream().map(arg_0 -> ((ProtocoloMapper)this.mapper).toExercicioDTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(dto);
    }

    @GetMapping(value={"/entidade-principal"})
    public ResponseEntity<EntidadeDTO> getEntidadePrincipal() {
        EntidadeDTO entidade = Optional.ofNullable(this.entidadeService.getEntidadeAtual()).map(arg_0 -> ((ProtocoloMapper)this.mapper).toEntidadeDTO(arg_0)).orElseThrow(RestException::notFound);
        return ResponseEntity.ok((Object)entidade);
    }

    private Entidade getEntidadeOrThrowNotFound(Long id) {
        return Optional.ofNullable((Entidade)this.entidadeService.findOne((Serializable)id)).orElseThrow(RestException::notFound);
    }

    @GetMapping(value={"/entidade-principal-usuario"})
    public ResponseEntity<EntidadeDTO> getEntidadePrincipalUsuario() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        EntidadeDTO dto = this.mapper.toEntidadeDTO(this.entidadeService.getEntidadePrincipalUsuario(auth.getName()));
        return ResponseEntity.ok((Object)dto);
    }

    @GetMapping(value={"/find-by-id-or-entidade-principal/{id}"})
    public ResponseEntity<EntidadeDTO> findByIdOrEntidadePrincipal(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.mapper.toEntidadeDTO(this.entidadeService.findByIdOrEntidadePrincipal(id)));
    }
}

