/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.EntidadeDTO;
import br.com.elotech.protocolo.service.EntidadeCloudService;
import org.springframework.context.annotation.Profile;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/entidades"})
@Profile(value={"cloud"})
public class EntidadeCloudResource {
    private final EntidadeCloudService entidadeCloudService;
    private final ProtocoloMapper protocoloMapper;

    public EntidadeCloudResource(EntidadeCloudService entidadeCloudService, ProtocoloMapper protocoloMapper) {
        this.entidadeCloudService = entidadeCloudService;
        this.protocoloMapper = protocoloMapper;
    }

    @GetMapping(value={"/entidade-principal-usuario-keycloak"})
    public ResponseEntity<EntidadeDTO> getEntidadePrincipalUsuarioKeycloak() {
        EntidadeDTO dto = this.protocoloMapper.toEntidadeDTO(this.entidadeCloudService.getEntidadePrincipalUsuarioKeycloak());
        return ResponseEntity.ok((Object)dto);
    }
}

