/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.domain.Diretoria;
import br.com.elotech.protocolo.domain.DiretoriaPK;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.dto.DiretoriaDTO;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/diretorias"})
public class DiretoriaResource
extends BaseResourceDTO<Diretoria, DiretoriaPK, DiretoriaDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiretoriaResource.class);

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    public ResponseEntity<DiretoriaDTO> findOne(@PathVariable Long id) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        DiretoriaPK diretoriaPK = DiretoriaPK.of((Entidade)entidade, (Long)id);
        log.debug("Buscando {}", (Object)diretoriaPK);
        return super.findOne((Serializable)diretoriaPK);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<DiretoriaDTO> save(@RequestBody @Valid DiretoriaDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        return super.save((Object)dto, authentication, builder, request);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    public ResponseEntity<DiretoriaDTO> update(@RequestBody @Valid DiretoriaDTO dto, @PathVariable Long id, Authentication authentication) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        DiretoriaPK diretoriaPK = DiretoriaPK.of((Entidade)entidade, (Long)id);
        return super.update((Object)dto, (Serializable)diretoriaPK, authentication);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable Long id) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        DiretoriaPK diretoriaPK = DiretoriaPK.of((Entidade)entidade, (Long)id);
        return super.remove((Serializable)diretoriaPK);
    }
}

