/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.protocolo.domain.DataIgnorada;
import br.com.elotech.protocolo.service.DataIgnoradaService;
import java.time.LocalDate;
import java.util.List;
import javax.validation.Valid;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/datasignoradas"})
public class DataIgnoradaResource
extends CrudResource<DataIgnorada, Long> {
    private final DataIgnoradaService dataIgnoradaService;

    public DataIgnoradaResource(DataIgnoradaService dataIgnoradaService) {
        this.dataIgnoradaService = dataIgnoradaService;
    }

    @PostMapping(value={"/save-periodo"})
    public ResponseEntity<List<DataIgnorada>> savePeriodo(@RequestBody @Valid DataIgnorada dataIgnorada) {
        return ResponseEntity.ok().body((Object)this.dataIgnoradaService.saveDataRange(dataIgnorada));
    }

    @GetMapping(value={"/tipo-andamento/{id}/data/{data}"})
    public ResponseEntity<LocalDate> sugereData(@PathVariable(value="id") Long id, @PathVariable(value="data") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate data) {
        return ResponseEntity.ok().body((Object)this.dataIgnoradaService.sugereData(id, data));
    }
}

