/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.dto.TramiteLocalDTO;
import br.com.elotech.protocolo.service.ProcessoAndamentoService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.ProtocoloConfigService;
import br.com.elotech.protocolo.service.TramiteService;
import br.com.elotech.protocolo.service.assinatura.AssinaturaService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import br.com.elotech.protocolo.web.rest.dto.chart.SerieItemDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dashboard"})
public class DashboardResource {
    private static final int PRECISAO = 0;
    private final TramiteService tramiteService;
    private final ProcessoPesquisaService processoPesquisaService;
    private final AssinaturaService assinaturaService;
    private final ProtocoloConfigService configService;
    private final ProcessoAndamentoService processoAndamentoService;

    @Autowired
    public DashboardResource(TramiteService tramiteService, ProcessoPesquisaService processoPesquisaService, AssinaturaService assinaturaService, ProtocoloConfigService configService, ProcessoAndamentoService processoAndamentoService) {
        this.tramiteService = tramiteService;
        this.processoPesquisaService = processoPesquisaService;
        this.assinaturaService = assinaturaService;
        this.configService = configService;
        this.processoAndamentoService = processoAndamentoService;
    }

    @GetMapping(value={"/tramitacao-mensal"})
    public ResponseEntity<List<SerieItemDTO>> getTramitacoesMensal(@RequestParam(name="data", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) Optional<LocalDate> dataBase) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Entidade entidade = new Entidade();
        entidade.setId(RequestHeaderHelper.getEntidadeLogada());
        Map queryResult = this.tramiteService.findTramitacoesMensal(entidade, authentication.getName(), dataBase.orElse(LocalDate.now()));
        List result = queryResult.keySet().stream().map(k -> new SerieItemDTO(k.getDescricao(), BigDecimal.valueOf((Long)queryResult.get(k)))).collect(Collectors.toList());
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/recebimento-count"})
    public ResponseEntity<SerieItemDTO> getQuantidadeProcessosReceber() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Long quantidade = this.processoPesquisaService.getQuantidadeProcessosReceber(authentication.getName());
        SerieItemDTO serie = new SerieItemDTO("Processos a Receber no Local", new BigDecimal(quantidade));
        return ResponseEntity.ok((Object)serie);
    }

    @GetMapping(value={"/recebimento-count-usuario"})
    public ResponseEntity<SerieItemDTO> getQuantidadeProcessosReceberPeloUsuario() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Long quantidade = this.processoPesquisaService.getQuantidadeProcessosReceberPeloUsuario(authentication.getName());
        SerieItemDTO serie = new SerieItemDTO("Processos a Receber pelo Usu\u00e1rio", new BigDecimal(quantidade));
        return ResponseEntity.ok((Object)serie);
    }

    @GetMapping(value={"/encaminhar-count"})
    public ResponseEntity<SerieItemDTO> getQuantidadeProcessosEncaminhar() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String rotulo = this.configService.getConfig().getIsProcessoMp() != false ? "Processos a Cumprir" : "Processos a Encaminhar";
        Long quantidade = this.processoPesquisaService.getQuantidadeProcessosEncaminhar(authentication.getName());
        SerieItemDTO serie = new SerieItemDTO(rotulo, new BigDecimal(quantidade));
        return ResponseEntity.ok((Object)serie);
    }

    @GetMapping(value={"/media-dias-parado"})
    public ResponseEntity<SerieItemDTO> getMediaDiasParadoSetor(@RequestHeader(value="EXERCICIO") Long exercicio) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Double mediaDiasSetor = this.tramiteService.getMediaDiasParadoSetor(exercicio, auth.getName(), RequestHeaderHelper.getEntidadeLogada()).orElse(BigDecimal.ZERO.doubleValue());
        SerieItemDTO serie = new SerieItemDTO("M\u00e9dia de Dias Parado no Local", BigDecimal.valueOf(mediaDiasSetor).setScale(0, RoundingMode.HALF_UP));
        return ResponseEntity.ok((Object)serie);
    }

    @GetMapping(value={"/quantidade-assinaturas-pendentes"})
    public ResponseEntity<SerieItemDTO> getQuantidadeAssinaturasPendentesByUsuario() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Long qtdProcessosPendentes = this.assinaturaService.getQuantidadeAssinaturasPendentesByUsuarioAndEntidade(auth.getName(), RequestHeaderHelper.getEntidadeLogada());
        return ResponseEntity.ok((Object)new SerieItemDTO("Assinaturas Pendentes", new BigDecimal(qtdProcessosPendentes)));
    }

    @GetMapping(value={"/quantidade-situacao-processos"})
    public ResponseEntity<List<SerieItemDTO>> getCoutProcessosSituacao(@RequestParam(name="data", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) Optional<LocalDate> dataBase) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return ResponseEntity.ok((Object)this.processoPesquisaService.quantidadeProcessosPorSituacao(dataBase, auth.getName(), this.configService.getCurrentTenantId()));
    }

    @GetMapping(value={"/tramites-por-local"})
    public ResponseEntity<List<TramiteLocalDTO>> getTramitacoesPorLocal(@RequestHeader(value="EXERCICIO") Long exercicio) {
        SecurityContextHolder.getContext().getAuthentication();
        List tramiteList = this.tramiteService.getTramitesPorLocalByAno(exercicio, RequestHeaderHelper.getEntidadeLogada());
        tramiteList.forEach(tramite -> tramite.setDescricao(tramite.getCodigo() + " - " + tramite.getDescricao()));
        return ResponseEntity.ok((Object)tramiteList);
    }

    @GetMapping(value={"/encaminhar-paralisado-count"})
    public ResponseEntity<SerieItemDTO> getQuantidadeProcessosEncaminharParalisado() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String rotulo = this.configService.getConfig().getIsProcessoMp() != false ? "Suspensos" : "Processos a Encaminhar(Paralisados)";
        Long quantidade = this.processoPesquisaService.getQuantidadeProcessosEncaminharParalisado(authentication.getName());
        SerieItemDTO serie = new SerieItemDTO(rotulo, new BigDecimal(quantidade));
        return ResponseEntity.ok((Object)serie);
    }

    @GetMapping(value={"/anexos-externos"})
    public ResponseEntity<SerieItemDTO> getQuantidadeAnexosExternos() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Long quantidade = this.processoAndamentoService.getQuantidadeAnexosExternos(auth.getName());
        SerieItemDTO serie = new SerieItemDTO("Novos Anexos Externos", new BigDecimal(quantidade));
        return ResponseEntity.ok((Object)serie);
    }

    @GetMapping(value={"/novos-comunicados"})
    public ResponseEntity<SerieItemDTO> getNovosComunicados() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Long quantidade = this.processoAndamentoService.getNovosComunicados(auth.getName());
        SerieItemDTO serie = new SerieItemDTO("Novos Comunicados", new BigDecimal(quantidade));
        return ResponseEntity.ok((Object)serie);
    }
}

