/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.web.rest.dto.chart.SerieItemDTO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dashboard-ouvidoria"})
public class DashboardOuvidoriaResource {
    private final ProcessoPesquisaService processoPesquisaService;

    @Autowired
    public DashboardOuvidoriaResource(ProcessoPesquisaService processoPesquisaService) {
        this.processoPesquisaService = processoPesquisaService;
    }

    @GetMapping(value={"/processo-por-tipo", "/processo-por-tipo/{entidade}"})
    public ResponseEntity<List<SerieItemDTO>> getQuantidadeProcessosOuvidoriaPorTipo(@PathVariable(name="entidade", required=false) Long entidade) {
        Map quantidadeProcessos = this.processoPesquisaService.getQuantidadeProcessosOuvidoriaPorTipo(entidade);
        List result = quantidadeProcessos.entrySet().stream().map(k -> new SerieItemDTO((String)k.getKey(), (BigDecimal)k.getValue())).collect(Collectors.toList());
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/processo-por-status", "/processo-por-status/{entidade}"})
    public ResponseEntity<List<SerieItemDTO>> getQuantidadeProcessosOuvidoriaPorStatus(@PathVariable(name="entidade", required=false) Long entidade) {
        Map quantidadeProcessos = this.processoPesquisaService.getQuantidadeProcessosOuvidoriaPorStatus(entidade);
        List result = quantidadeProcessos.entrySet().stream().map(k -> new SerieItemDTO((String)k.getKey(), (BigDecimal)k.getValue())).collect(Collectors.toList());
        return ResponseEntity.ok(result);
    }
}

