/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import java.util.Date;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cubejs"})
public class CubeJsResource {
    private final String cubeJsApiSecret;
    private static final Long ONE_DAY_IN_SECONDS = 86400L;

    public CubeJsResource(@Value(value="${elotech.cubejsApiSecret}") String cubeJsApiSecret) {
        this.cubeJsApiSecret = cubeJsApiSecret;
    }

    @GetMapping(value={"/auth"})
    public ResponseEntity<String> auth() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Date now = new Date();
        String token = JWT.create().withSubject(authentication.getName()).withIssuedAt(now).withExpiresAt(new Date(now.getTime() + ONE_DAY_IN_SECONDS)).sign(Algorithm.HMAC512((String)this.cubeJsApiSecret));
        return ResponseEntity.ok((Object)token);
    }
}

