/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.domain.Coordenadoria;
import br.com.elotech.protocolo.domain.CoordenadoriaPK;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.dto.CoordenadoriaDTO;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/coordenadorias"})
public class CoordenadoriaResource
extends BaseResourceDTO<Coordenadoria, CoordenadoriaPK, CoordenadoriaDTO> {
    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    public ResponseEntity<CoordenadoriaDTO> findOne(@PathVariable Long id) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        CoordenadoriaPK coordenadoriaPK = CoordenadoriaPK.of((Entidade)entidade, (Long)id);
        return super.findOne((Serializable)coordenadoriaPK);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<CoordenadoriaDTO> save(@RequestBody @Valid CoordenadoriaDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        return super.save((Object)dto, authentication, builder, request);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    public ResponseEntity<CoordenadoriaDTO> update(@RequestBody @Valid CoordenadoriaDTO dto, @PathVariable Long id, Authentication authentication) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        CoordenadoriaPK pk = CoordenadoriaPK.of((Entidade)entidade, (Long)id);
        return super.update((Object)dto, (Serializable)pk, authentication);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable Long id) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        return super.remove((Serializable)CoordenadoriaPK.of((Entidade)entidade, (Long)id));
    }
}

