/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.converter.ProcessoDTOConverter;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.ProcessoArquivoDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.ProcessoRequerenteDTO;
import br.com.elotech.protocolo.exception.TokenException;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.PessoaService;
import br.com.elotech.protocolo.service.ProcessoObservadorExternoService;
import br.com.elotech.protocolo.service.ProcessoTokenService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/consultaprocesso"})
public class ConsultaProcessoResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsultaProcessoResource.class);
    private static final String SENHA = "elo123";
    private final ParametroService parametroService;
    private final ProcessoRepository processoRepository;
    private final PessoaService pessoaService;
    private final ProtocoloMapper mapper;
    private final ProcessoObservadorExternoService processoObservadorExternoService;
    private final EntityManager em;
    private final ProcessoTokenService processoTokenService;

    public ConsultaProcessoResource(ParametroService parametroService, ProcessoRepository processoRepository, ProtocoloMapper mapper, PessoaService pessoaService, ProcessoObservadorExternoService processoObservadorExternoService, EntityManager em, ProcessoTokenService processoTokenService) {
        this.parametroService = parametroService;
        this.processoRepository = processoRepository;
        this.mapper = mapper;
        this.pessoaService = pessoaService;
        this.processoObservadorExternoService = processoObservadorExternoService;
        this.em = em;
        this.processoTokenService = processoTokenService;
    }

    @GetMapping(value={"/obriga-senha", "/obriga-senha/{idEntidade}"})
    public ResponseEntity<Boolean> consultaParamObrigaSenha(@PathVariable(name="idEntidade", required=false) Long idEntidade) {
        if (!Objects.isNull(idEntidade)) {
            return ResponseEntity.ok((Object)this.parametroService.getParamValueAsBoolean(ParametroEnum.OBRIGA_SENHA_CONSULTA_PROCESSOEXTERNO, Entidade.of((Long)idEntidade), Long.valueOf(LocalDate.now().getYear())));
        }
        return ResponseEntity.ok((Object)this.parametroService.getParamValueAsBoolean(ParametroEnum.OBRIGA_SENHA_CONSULTA_PROCESSOEXTERNO.getCodigo()));
    }

    @GetMapping
    @Transactional(readOnly=true)
    public ResponseEntity<ProcessoDTO> findProcesso(@RequestParam(name="tipo") Long tipo, @RequestParam(name="ano") Long ano, @RequestParam(name="numero") Long numero, @RequestParam(name="cpfSenha") String cpfSenha, @RequestParam(name="entidade", required=false) Long idEntidade, @RequestHeader(name="Token-Cidadao", required=false) String tokenCidadao) {
        boolean obrigaInformarSenha = Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.OBRIGA_SENHA_CONSULTA_PROCESSOEXTERNO.getCodigo()));
        try {
            if (obrigaInformarSenha && this.processoTokenService.isTokenCidadaoValid(tokenCidadao, cpfSenha)) {
                obrigaInformarSenha = false;
            }
        }
        catch (TokenException e) {
            String message = "N\u00e3o foi poss\u00edvel utilizar o Token recebido para carregar o processo";
            if (e.isFatal()) {
                log.error(message, (Throwable)e);
            }
            log.warn(message, (Throwable)e);
        }
        Processo processo = obrigaInformarSenha ? this.findProcessoComSenha(ano, tipo, numero, cpfSenha, idEntidade) : this.findProcessoSemSenha(ano, tipo, numero, cpfSenha, idEntidade);
        if (Objects.isNull(processo)) {
            throw RestException.notFound((String)"Processo n\u00e3o encontrado.");
        }
        processo.getArquivos().removeIf(arq -> processo.getTramites().stream().anyMatch(tramite -> Objects.equals(tramite.getSequencia(), arq.getSequenciaTramitacao()) && tramite.getNotaPrivada() != false));
        this.processoObservadorExternoService.removeArquivosSigilosos(processo);
        processo.getTramites().forEach(tramite -> {
            if (Boolean.TRUE.equals(tramite.getNotaPrivada())) {
                tramite.setParecer("");
            }
        });
        ProcessoDTO dto = this.mapper.toProcessoDTO(processo);
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        if (Boolean.TRUE.equals(isOrdemCrescenteAnexo)) {
            dto.getArquivos().sort(Comparator.comparing(ProcessoArquivoDTO::getOrdem));
        } else {
            dto.getArquivos().sort(Comparator.comparing(ProcessoArquivoDTO::getOrdem).reversed());
        }
        this.em.detach((Object)processo);
        return ResponseEntity.ok((Object)dto);
    }

    private Processo findProcessoComSenha(Long ano, Long tipo, Long numero, String cpfSenha, Long idEntidade) {
        if (Objects.isNull(idEntidade)) {
            return this.processoObservadorExternoService.removeArquivosSigilosos(this.processoRepository.findOneByAnoTipoNumeroAndSenha(ano, tipo, numero, cpfSenha));
        }
        return this.processoObservadorExternoService.removeArquivosSigilosos(this.processoRepository.findOneByAnoTipoNumeroAndSenhaAndEntidade(ano, tipo, numero, cpfSenha, idEntidade));
    }

    private Processo findProcessoSemSenha(Long ano, Long tipo, Long numero, String cpfSenha, Long idEntidade) {
        if (Objects.isNull(idEntidade)) {
            return this.processoObservadorExternoService.removeArquivosSigilosos(this.processoRepository.findOneByAnoTipoNumeroAndSenhaOrCnpj(ano, tipo, numero, cpfSenha));
        }
        return this.processoObservadorExternoService.removeArquivosSigilosos(this.processoRepository.findOneByAnoTipoNumeroAndSenhaOrCnpjAndEntidade(ano, tipo, numero, cpfSenha, idEntidade));
    }

    @GetMapping(value={"/requerente/{codPessoa}/{senha}"})
    public ResponseEntity<List<ProcessoRequerenteDTO>> findProcessoByRequerente(@PathVariable(name="codPessoa") Long codPessoa, @PathVariable String senha) {
        if (!SENHA.equals(senha)) {
            throw new RestException(HttpStatus.BAD_REQUEST, "Senha digitada n\u00e3o confere.");
        }
        List processos = this.processoRepository.findByPessoaId(codPessoa);
        return ResponseEntity.ok((Object)processos);
    }

    @GetMapping(value={"/requerente/cpfcnpj/{cpfCnpj}/senha/{senha}"})
    public ResponseEntity<List<ProcessoRequerenteDTO>> findProcessoByRequerenteCpfCnpj(@PathVariable(name="cpfCnpj") String cpfCnpj, @PathVariable(name="senha") String senha) {
        if (!SENHA.equals(senha)) {
            throw new RestException(HttpStatus.BAD_REQUEST, "Senha digitada n\u00e3o confere.");
        }
        List pessoasList = this.pessoaService.getPessoaByCnpjCpfOrderById(cpfCnpj);
        if (pessoasList.isEmpty()) {
            throw new RestException(HttpStatus.NO_CONTENT, "N\u00e3o foi encontrado nenhuma pessoa com este cpf/cnpj.");
        }
        ArrayList processos = new ArrayList();
        for (Pessoa pessoa : pessoasList) {
            processos.addAll(this.processoRepository.findByPessoaId(pessoa.getId()));
        }
        return ResponseEntity.ok(processos);
    }

    @GetMapping(value={"/chave"})
    public ResponseEntity<ProcessoDTO> findProcessoByCpfAndChave(@RequestParam(name="cpf") String cpf, @RequestParam(name="chave") String chave) {
        Processo processo = this.processoObservadorExternoService.findProcessoByCpfAndChave(cpf, chave);
        ProcessoDTO processoDTO = new ProcessoDTOConverter().to(processo, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        processoDTO.getArquivos().removeIf(arquivo -> Boolean.TRUE.equals(arquivo.getSigiloExterno()));
        return ResponseEntity.ok((Object)processoDTO);
    }
}

