/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.TipoProcessoDTO;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.TipoProcessoService;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/consultaprocesso-integracao"})
public class ConsultaProcessoIntegracaoResource {
    private final ProtocoloMapper mapper;
    private final ParametroService parametroService;
    private final TipoProcessoService tipoProcessoService;
    private final ProcessoPesquisaService processoPesquisaService;

    public ConsultaProcessoIntegracaoResource(ProtocoloMapper mapper, ParametroService parametroService, ProcessoPesquisaService processoPesquisaService, TipoProcessoService tipoProcessoService) {
        this.mapper = mapper;
        this.parametroService = parametroService;
        this.processoPesquisaService = processoPesquisaService;
        this.tipoProcessoService = tipoProcessoService;
    }

    @GetMapping(value={"/gerais"})
    public ResponseEntity<Page<ProcessoDTO>> findProcessosGeraisByAssunto(@RequestParam(value="idAssunto", required=false) Long idAssunto, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page result = this.processoPesquisaService.findProcessosAbertosParaSistemasInternos(idAssunto, search, pageable);
        return ResponseEntity.ok((Object)result.map(arg_0 -> ((ProtocoloMapper)this.mapper).toProcessoDTO(arg_0)));
    }

    @GetMapping(value={"/{entidade}/{ano}/{tipo}/{numero}"})
    public ResponseEntity<ProcessoDTO> findOne(@PathVariable(name="entidade") Long entidade, @PathVariable(name="ano") Long ano, @PathVariable(name="tipo") Long tipo, @PathVariable(name="numero") Long numero) {
        Processo result = this.processoPesquisaService.loadProcesso(Entidade.of((Long)entidade), tipo, numero, ano);
        return ResponseEntity.ok((Object)this.mapper.toProcessoDTO(result));
    }

    @GetMapping(value={"/{uuid}"})
    public ResponseEntity<ProcessoDTO> findByUuid(@PathVariable(name="uuid") String uuid) {
        Processo result = this.processoPesquisaService.findByUuid(uuid);
        return ResponseEntity.ok((Object)this.mapper.toProcessoDTO(result));
    }

    @GetMapping(value={"/url-externo"})
    public ResponseEntity<String> consultaUrlExternaProcesso() {
        return ResponseEntity.ok((Object)this.parametroService.getParamValueAsString(ParametroEnum.URL_ABERTURA_EXTERNA_PORTALTRANSPARENCIA.getCodigo()));
    }

    @GetMapping(value={"/tipos-processo"})
    public ResponseEntity<List<TipoProcessoDTO>> findTiposProcesso() {
        Page result = this.tipoProcessoService.findAll(Pageable.unpaged());
        return ResponseEntity.ok((Object)result.map(arg_0 -> ((ProtocoloMapper)this.mapper).toTipoProcessoDTO(arg_0)).toList());
    }
}

