/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.domain.Caixa;
import br.com.elotech.protocolo.domain.CaixaPK;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.CaixaDTO;
import br.com.elotech.protocolo.service.CaixaService;
import java.io.Serializable;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/caixas"})
public class CaixaResource
extends BaseResourceDTO<Caixa, CaixaPK, CaixaDTO> {
    @Autowired
    private CaixaService service;
    @Autowired
    private ProtocoloMapper mapper;

    @RequestMapping(method={RequestMethod.GET}, params={"codigo", "ano"})
    public ResponseEntity<CaixaDTO> findcaixa(@RequestParam(value="codigo") Long codigo, @RequestParam(value="ano") Long ano) {
        Caixa caixa = this.loadCaixa(codigo, ano);
        return ResponseEntity.ok((Object)this.mapper.toCaixaDTO(caixa));
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<CaixaDTO> save(@RequestBody @Valid CaixaDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        return super.save((Object)dto, authentication, builder, request);
    }

    @RequestMapping(params={"codigo", "ano"}, method={RequestMethod.PUT})
    public ResponseEntity<CaixaDTO> update(@RequestBody @Valid CaixaDTO dto, @RequestParam(value="codigo") Long codigo, @RequestParam(value="ano") Long ano, Authentication authentication) {
        return super.update((Object)dto, (Serializable)CaixaPK.of((Long)codigo, (Long)ano), authentication);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    public ResponseEntity<Void> remove(@RequestParam(value="codigo") Long codigo, @RequestParam(value="ano") Long ano, Authentication authentication) {
        return super.remove((Serializable)CaixaPK.of((Long)codigo, (Long)ano));
    }

    private Caixa loadCaixa(Long codigo, Long ano) {
        CaixaPK pk = this.loadPkById(codigo, ano);
        Caixa caixa = (Caixa)this.service.findOne((Serializable)pk);
        return Optional.ofNullable(caixa).orElseThrow(RestException::notFound);
    }

    private CaixaPK loadPkById(Long codigo, Long ano) {
        return CaixaPK.of((Long)codigo, (Long)ano);
    }
}

