/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.audit.domain.RevisionRecord;
import br.com.elotech.audit.reader.RevisionReader;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.core.web.rest.dto.DTOConverter;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import br.com.elotech.protocolo.dto.AssuntoPesquisaDTO;
import br.com.elotech.protocolo.service.AssuntoService;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/assuntos"})
public class AssuntoResource
extends BaseResourceDTO<Assunto, Long, AssuntoDTO> {
    private final RevisionReader reader;
    private final AssuntoService assuntoService;
    private final ProtocoloMapper protocoloMapper;

    public AssuntoResource(RevisionReader reader, AssuntoService assuntoService, ProtocoloMapper protocoloMapper) {
        this.reader = reader;
        this.assuntoService = assuntoService;
        this.protocoloMapper = protocoloMapper;
    }

    public AssuntoService getService() {
        return (AssuntoService)super.getService();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    public ResponseEntity<AssuntoDTO> findOne(@PathVariable Long id) {
        return super.findOne((Serializable)id);
    }

    @Transactional
    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<AssuntoDTO> save(@RequestBody @Valid AssuntoDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        return super.save((Object)dto, authentication, builder, request);
    }

    @Transactional
    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    public ResponseEntity<AssuntoDTO> update(@RequestBody @Valid AssuntoDTO dto, @PathVariable(value="id") Long id, Authentication authentication) {
        this.validarAssuntoPai(dto, dto.getAssuntoPai());
        return super.update((Object)dto, (Serializable)id, authentication);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable(value="id") Long id) {
        this.assuntoService.validateDelete(id);
        return super.remove((Serializable)id);
    }

    @GetMapping(value={"/history"}, params={"id"})
    public ResponseEntity<List<RevisionRecord>> findAllHistory(Long id) {
        return ResponseEntity.ok((Object)this.reader.findHistory(Assunto.class, (Serializable)id));
    }

    @GetMapping(value={"/assunto-pai/{id}"})
    public ResponseEntity<List<AssuntoDTO>> findAllByAssuntoPai(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.findAllByAssuntoPaiId(id));
    }

    @GetMapping(value={"/find-all-filtrado-entidade"})
    public ResponseEntity<List<AssuntoDTO>> findAllNew(@RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="entidadeAtual", required=false) Long entidadeAtual, @RequestParam(value="tipoProcessoId", required=false) Long tipoProcessoId, Pageable pageable) {
        return ResponseEntity.ok(this.assuntoService.findAllComFiltroDeEntidadeETipoProcesso(search, entidadeAtual, pageable, tipoProcessoId).stream().map(arg_0 -> ((ProtocoloMapper)this.protocoloMapper).toAssuntoDTO(arg_0)).collect(Collectors.toList()));
    }

    @GetMapping(value={"/pesquisa"})
    public ResponseEntity<List<AssuntoPesquisaDTO>> findAllPesquisa(@RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="entidadeAtual", required=false) Long entidadeAtual, @RequestParam(value="tipoProcessoId", required=false) Long tipoProcessoId, Pageable pageable) {
        return ResponseEntity.ok(this.assuntoService.findAllComFiltroDeEntidadeETipoProcesso(search, entidadeAtual, pageable, tipoProcessoId).stream().map(arg_0 -> ((ProtocoloMapper)this.protocoloMapper).toAssuntoPesquisaDTO(arg_0)).collect(Collectors.toList()));
    }

    @GetMapping(value={"/assuntos-mais-utilizados"})
    public ResponseEntity<List<AssuntoDTO>> assuntosMaisUtilizados(@RequestParam(value="username", required=false) String username) {
        return ResponseEntity.ok((Object)this.assuntoService.assuntosMaisUtilizados(username));
    }

    private List<AssuntoDTO> findAllByAssuntoPaiId(Long id) {
        return this.getService().findAllByAssuntoPaiId(id).stream().map(arg_0 -> ((DTOConverter)this.getConverter()).to(arg_0)).sorted(Comparator.comparing(AssuntoDTO::getId)).collect(Collectors.toList());
    }

    private void validarAssuntoPai(AssuntoDTO dto, AssuntoDTO assuntoPai) {
        if (Objects.nonNull(dto.getAssuntoPai()) && Objects.nonNull(assuntoPai)) {
            List assuntos = this.findAllByAssuntoPaiId(dto.getId());
            for (AssuntoDTO assunto : assuntos) {
                if (assunto.getId().equals(dto.getAssuntoPai().getId()) || assuntoPai.getId().equals(assunto.getId())) {
                    throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o \u00e9 poss\u00edvel atribuir este assunto pai, o mesmo j\u00e1 est\u00e1 vinculado como filho em alguma hierarquia.");
                }
                this.validarAssuntoPai(assunto, assuntoPai);
            }
        }
    }

    @PostMapping(value={"/republish"})
    public ResponseEntity<Void> republish() {
        this.assuntoService.republish();
        return ResponseEntity.ok().build();
    }
}

