/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.protocolo.domain.AssinaturaConfiguracao;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.service.AssinaturaConfiguracaoService;
import br.com.elotech.protocolo.service.arquivo.ArquivoService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/assinaturas-configuracao"})
public class AssinaturaConfiguracaoResource
extends CrudResource<AssinaturaConfiguracao, Long> {
    @Autowired
    private ArquivoService arquivoService;

    public AssinaturaConfiguracaoService getService() {
        return (AssinaturaConfiguracaoService)super.getService();
    }

    @PostMapping(value={"/{id}/arquivo/{tipo}"})
    public ResponseEntity<AssinaturaConfiguracao> addArquivo(@PathVariable(name="tipo") String tipo, @PathVariable(name="id") Long id, @RequestParam(value="files") MultipartFile file) throws IOException {
        AssinaturaConfiguracao config = (AssinaturaConfiguracao)this.getService().findOne((Serializable)id);
        return ResponseEntity.ok((Object)this.getService().addArquivo(config, file, tipo));
    }

    @DeleteMapping(value={"/{id}/arquivo/{tipo}/{idArquivo}"})
    public ResponseEntity<AssinaturaConfiguracao> deleteArquivo(@PathVariable(name="tipo") String tipo, @PathVariable(name="id") Long id, @PathVariable(name="idArquivo") Long idArquivo) {
        AssinaturaConfiguracao config = (AssinaturaConfiguracao)this.getService().findOne((Serializable)id);
        return ResponseEntity.ok((Object)this.getService().deleteArquivo(config, idArquivo, tipo));
    }

    @GetMapping(value={"/get-config-by-entidade"})
    public ResponseEntity<AssinaturaConfiguracao> getConfigByEntidade() {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        AssinaturaConfiguracao configuracao = this.getService().findByEntidade(entidade.getId());
        if (Objects.nonNull(configuracao)) {
            Optional.ofNullable(configuracao.getCarimboArquivoId()).flatMap(arg_0 -> ((ArquivoService)this.arquivoService).downloadArquivo(arg_0)).ifPresent(arg_0 -> ((AssinaturaConfiguracao)configuracao).setCarimboArquivo(arg_0));
        }
        return ResponseEntity.ok((Object)configuracao);
    }
}

