/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.resolvers;

import br.com.elotech.core.config.ElotechHandlerMethodArgumentResolver;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.repository.EntidadeRepository;
import br.com.elotech.protocolo.web.resolvers.HeaderEntidade;
import com.google.common.base.Strings;
import com.google.common.primitives.Longs;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class EntidadeArgumentResolver
implements ElotechHandlerMethodArgumentResolver {
    private static final String NULLSTR = "null";
    private final EntidadeRepository entidadeRepository;

    public EntidadeArgumentResolver(EntidadeRepository entidadeRepository) {
        this.entidadeRepository = entidadeRepository;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(HeaderEntidade.class) && Entidade.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        String entidade = webRequest.getHeader("ENTIDADE");
        if (Strings.isNullOrEmpty((String)entidade) || NULLSTR.equalsIgnoreCase(entidade)) {
            return null;
        }
        Long entidadeLong = Longs.tryParse((String)entidade);
        return this.entidadeRepository.findOne((Object)entidadeLong);
    }
}

