/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.filter;

import br.com.elotech.core.config.ElotechProperties;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class CachingHttpHeadersFilter
implements Filter {
    private static final long DIAS = 1461L;
    private static final long LAST_MODIFIED = System.currentTimeMillis();
    private long cacheTimeToLive = TimeUnit.DAYS.toMillis(1461L);
    private final ElotechProperties elotechProperties;

    public CachingHttpHeadersFilter(ElotechProperties elotechProperties) {
        this.elotechProperties = elotechProperties;
    }

    public void init(FilterConfig filterConfig) {
        this.cacheTimeToLive = TimeUnit.DAYS.toMillis(this.elotechProperties.getHttp().getCache().getTimeToLiveInDays());
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setHeader("Cache-Control", "max-age=" + this.cacheTimeToLive + ", public");
        httpResponse.setHeader("Pragma", "cache");
        httpResponse.setDateHeader("Expires", this.cacheTimeToLive + System.currentTimeMillis());
        httpResponse.setDateHeader("Last-Modified", LAST_MODIFIED);
        chain.doFilter(request, response);
    }
}

