/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.controller.params;

import java.sql.Date;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class RelatorioTramiteParams {
    private static final LocalDate DEFAULT_START_DATE = LocalDate.of(1900, 1, 1);
    private static final LocalDate DEFAULT_END_DATE = LocalDate.of(2099, 12, 31);
    private static final Long DEFAULT_NUMBER = -99L;
    private static final String DEFAULT_STRING = "(TODOS)";
    private static final String DEFAULT_REPORT = "PADRAO";
    private Long entidade;
    private Long exercicio;
    private String parecer;
    private Long anoini = DEFAULT_NUMBER;
    private Long anofim = DEFAULT_NUMBER;
    private Long tipo = DEFAULT_NUMBER;
    private Long numeroini = DEFAULT_NUMBER;
    private Long numerofim = DEFAULT_NUMBER;
    private LocalDate dataprocini = DEFAULT_START_DATE;
    private LocalDate dataprocinidefault = DEFAULT_START_DATE;
    private LocalDate dataprocfim = DEFAULT_END_DATE;
    private LocalDate dataprocfimdefault = DEFAULT_END_DATE;
    private LocalDate datatramiteini = DEFAULT_START_DATE;
    private LocalDate datatramiteinidefault = DEFAULT_START_DATE;
    private LocalDate datatramitefim = DEFAULT_END_DATE;
    private LocalDate datatramitefimdefault = DEFAULT_END_DATE;
    private Boolean exportarExcel;
    private Long pessoa = DEFAULT_NUMBER;
    private Long situacao = DEFAULT_NUMBER;
    private Long assunto = DEFAULT_NUMBER;
    private Long localdestinoini = DEFAULT_NUMBER;
    private Long localdestinofim = DEFAULT_NUMBER;
    private Long lote = DEFAULT_NUMBER;
    private Long localbase = DEFAULT_NUMBER;
    private String reportOptions = "PADRAO";

    public Long getEntidade() {
        return Optional.ofNullable(this.entidade).orElse(DEFAULT_NUMBER);
    }

    public Long getExercicio() {
        return Optional.ofNullable(this.exercicio).orElse(DEFAULT_NUMBER);
    }

    public Long getAnoIni() {
        return Optional.ofNullable(this.anoini).orElse(DEFAULT_NUMBER);
    }

    public Long getAnoFim() {
        return Optional.ofNullable(this.anofim).orElse(DEFAULT_NUMBER);
    }

    public Long getTipo() {
        return Optional.ofNullable(this.tipo).orElse(DEFAULT_NUMBER);
    }

    public Long getNumeroIni() {
        return Optional.ofNullable(this.numeroini).orElse(DEFAULT_NUMBER);
    }

    public Long getNumeroFim() {
        return Optional.ofNullable(this.numerofim).orElse(DEFAULT_NUMBER);
    }

    public LocalDate getDataProcInidefault() {
        return Optional.ofNullable(this.dataprocinidefault).orElse(DEFAULT_START_DATE);
    }

    public LocalDate getDataProcIni() {
        return Optional.ofNullable(this.dataprocini).orElse(DEFAULT_START_DATE);
    }

    public LocalDate getDataprocfim() {
        return Optional.ofNullable(this.dataprocfim).orElse(DEFAULT_END_DATE);
    }

    public LocalDate getDataprocfimdefault() {
        return Optional.ofNullable(this.dataprocfimdefault).orElse(DEFAULT_END_DATE);
    }

    public LocalDate getDataTramiteInidefault() {
        return Optional.ofNullable(this.datatramiteinidefault).orElse(DEFAULT_START_DATE);
    }

    public LocalDate getDataTramiteIni() {
        return Optional.ofNullable(this.datatramiteini).orElse(DEFAULT_START_DATE);
    }

    public LocalDate getDataTramiteFimDefault() {
        return Optional.ofNullable(this.datatramitefimdefault).orElse(DEFAULT_END_DATE);
    }

    public LocalDate getDataTramiteFim() {
        return Optional.ofNullable(this.datatramitefim).orElse(DEFAULT_END_DATE);
    }

    public Long getPessoa() {
        return Optional.ofNullable(this.pessoa).orElse(DEFAULT_NUMBER);
    }

    public Long getSituacao() {
        return Optional.ofNullable(this.situacao).orElse(DEFAULT_NUMBER);
    }

    public Long getAssunto() {
        return Optional.ofNullable(this.assunto).orElse(DEFAULT_NUMBER);
    }

    public Long getLocalDestinoIni() {
        return Optional.ofNullable(this.localdestinoini).orElse(DEFAULT_NUMBER);
    }

    public Long getLocalDestinoFim() {
        return Optional.ofNullable(this.localdestinofim).orElse(DEFAULT_NUMBER);
    }

    public Long getLocalBase() {
        return Optional.ofNullable(this.localbase).orElse(DEFAULT_NUMBER);
    }

    public Long getLote() {
        return Optional.ofNullable(this.lote).orElse(DEFAULT_NUMBER);
    }

    public String getParecer() {
        if (Objects.isNull(this.parecer) || this.parecer.isEmpty()) {
            return DEFAULT_STRING;
        }
        return String.format("%%%s%%", this.parecer).replaceAll("%%", "%");
    }

    public String getReportOptions() {
        if (Objects.isNull(this.reportOptions) || this.reportOptions.isEmpty()) {
            return DEFAULT_REPORT;
        }
        return this.reportOptions;
    }

    public MapSqlParameterSource toJdbcParameters() {
        if (Objects.isNull(this.entidade)) {
            throw new IllegalArgumentException("A entidade n\u00e3o pode ser nula");
        }
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)this.getEntidade(), -5);
        params.addValue("exercicio", (Object)this.getExercicio(), -5);
        params.addValue("anoini", (Object)this.getAnoIni(), -5);
        params.addValue("anofim", (Object)this.getAnoFim(), -5);
        params.addValue("tipo", (Object)this.getTipo(), -5);
        params.addValue("numeroini", (Object)this.getNumeroIni(), -5);
        params.addValue("numerofim", (Object)this.getNumeroFim(), -5);
        params.addValue("dataprocini", (Object)Date.valueOf(this.getDataProcIni()), 91);
        params.addValue("dataprocinidefault", (Object)Date.valueOf(this.getDataProcInidefault()), 91);
        params.addValue("dataprocfim", (Object)Date.valueOf(this.getDataprocfim()), 91);
        params.addValue("dataprocfimdefault", (Object)Date.valueOf(this.getDataprocfimdefault()), 91);
        params.addValue("datatramiteini", (Object)Date.valueOf(this.getDataTramiteIni()), 91);
        params.addValue("datatramiteinidefault", (Object)Date.valueOf(this.getDataTramiteInidefault()), 91);
        params.addValue("datatramitefim", (Object)Date.valueOf(this.getDataTramiteFim()), 91);
        params.addValue("datatramitefimdefault", (Object)Date.valueOf(this.getDataTramiteFimDefault()), 91);
        params.addValue("pessoa", (Object)this.getPessoa(), -5);
        params.addValue("situacao", (Object)this.getSituacao(), -5);
        params.addValue("assunto", (Object)this.getAssunto(), -5);
        params.addValue("localdestinoini", (Object)this.getLocalDestinoIni(), -5);
        params.addValue("localdestinofim", (Object)this.getLocalDestinoFim(), -5);
        params.addValue("parecer", (Object)this.getParecer(), 12);
        params.addValue("lote", (Object)this.getLote(), -5);
        params.addValue("localbase", (Object)this.getLocalBase(), -5);
        return params;
    }

    @Generated
    public Boolean getExportarExcel() {
        return this.exportarExcel;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setParecer(String parecer) {
        this.parecer = parecer;
    }

    @Generated
    public void setAnoini(Long anoini) {
        this.anoini = anoini;
    }

    @Generated
    public void setAnofim(Long anofim) {
        this.anofim = anofim;
    }

    @Generated
    public void setTipo(Long tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setNumeroini(Long numeroini) {
        this.numeroini = numeroini;
    }

    @Generated
    public void setNumerofim(Long numerofim) {
        this.numerofim = numerofim;
    }

    @Generated
    public void setDataprocini(LocalDate dataprocini) {
        this.dataprocini = dataprocini;
    }

    @Generated
    public void setDataprocinidefault(LocalDate dataprocinidefault) {
        this.dataprocinidefault = dataprocinidefault;
    }

    @Generated
    public void setDataprocfim(LocalDate dataprocfim) {
        this.dataprocfim = dataprocfim;
    }

    @Generated
    public void setDataprocfimdefault(LocalDate dataprocfimdefault) {
        this.dataprocfimdefault = dataprocfimdefault;
    }

    @Generated
    public void setDatatramiteini(LocalDate datatramiteini) {
        this.datatramiteini = datatramiteini;
    }

    @Generated
    public void setDatatramiteinidefault(LocalDate datatramiteinidefault) {
        this.datatramiteinidefault = datatramiteinidefault;
    }

    @Generated
    public void setDatatramitefim(LocalDate datatramitefim) {
        this.datatramitefim = datatramitefim;
    }

    @Generated
    public void setDatatramitefimdefault(LocalDate datatramitefimdefault) {
        this.datatramitefimdefault = datatramitefimdefault;
    }

    @Generated
    public void setExportarExcel(Boolean exportarExcel) {
        this.exportarExcel = exportarExcel;
    }

    @Generated
    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setSituacao(Long situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setAssunto(Long assunto) {
        this.assunto = assunto;
    }

    @Generated
    public void setLocaldestinoini(Long localdestinoini) {
        this.localdestinoini = localdestinoini;
    }

    @Generated
    public void setLocaldestinofim(Long localdestinofim) {
        this.localdestinofim = localdestinofim;
    }

    @Generated
    public void setLote(Long lote) {
        this.lote = lote;
    }

    @Generated
    public void setLocalbase(Long localbase) {
        this.localbase = localbase;
    }

    @Generated
    public void setReportOptions(String reportOptions) {
        this.reportOptions = reportOptions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelatorioTramiteParams)) {
            return false;
        }
        RelatorioTramiteParams other = (RelatorioTramiteParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$anoini = this.getAnoIni();
        Long other$anoini = other.getAnoIni();
        if (this$anoini == null ? other$anoini != null : !((Object)this$anoini).equals(other$anoini)) {
            return false;
        }
        Long this$anofim = this.getAnoFim();
        Long other$anofim = other.getAnoFim();
        if (this$anofim == null ? other$anofim != null : !((Object)this$anofim).equals(other$anofim)) {
            return false;
        }
        Long this$tipo = this.getTipo();
        Long other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !((Object)this$tipo).equals(other$tipo)) {
            return false;
        }
        Long this$numeroini = this.getNumeroIni();
        Long other$numeroini = other.getNumeroIni();
        if (this$numeroini == null ? other$numeroini != null : !((Object)this$numeroini).equals(other$numeroini)) {
            return false;
        }
        Long this$numerofim = this.getNumeroFim();
        Long other$numerofim = other.getNumeroFim();
        if (this$numerofim == null ? other$numerofim != null : !((Object)this$numerofim).equals(other$numerofim)) {
            return false;
        }
        Boolean this$exportarExcel = this.getExportarExcel();
        Boolean other$exportarExcel = other.getExportarExcel();
        if (this$exportarExcel == null ? other$exportarExcel != null : !((Object)this$exportarExcel).equals(other$exportarExcel)) {
            return false;
        }
        Long this$pessoa = this.getPessoa();
        Long other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !((Object)this$pessoa).equals(other$pessoa)) {
            return false;
        }
        Long this$situacao = this.getSituacao();
        Long other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !((Object)this$situacao).equals(other$situacao)) {
            return false;
        }
        Long this$assunto = this.getAssunto();
        Long other$assunto = other.getAssunto();
        if (this$assunto == null ? other$assunto != null : !((Object)this$assunto).equals(other$assunto)) {
            return false;
        }
        Long this$localdestinoini = this.getLocalDestinoIni();
        Long other$localdestinoini = other.getLocalDestinoIni();
        if (this$localdestinoini == null ? other$localdestinoini != null : !((Object)this$localdestinoini).equals(other$localdestinoini)) {
            return false;
        }
        Long this$localdestinofim = this.getLocalDestinoFim();
        Long other$localdestinofim = other.getLocalDestinoFim();
        if (this$localdestinofim == null ? other$localdestinofim != null : !((Object)this$localdestinofim).equals(other$localdestinofim)) {
            return false;
        }
        Long this$lote = this.getLote();
        Long other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !((Object)this$lote).equals(other$lote)) {
            return false;
        }
        Long this$localbase = this.getLocalBase();
        Long other$localbase = other.getLocalBase();
        if (this$localbase == null ? other$localbase != null : !((Object)this$localbase).equals(other$localbase)) {
            return false;
        }
        String this$parecer = this.getParecer();
        String other$parecer = other.getParecer();
        if (this$parecer == null ? other$parecer != null : !this$parecer.equals(other$parecer)) {
            return false;
        }
        LocalDate this$dataprocini = this.getDataProcIni();
        LocalDate other$dataprocini = other.getDataProcIni();
        if (this$dataprocini == null ? other$dataprocini != null : !((Object)this$dataprocini).equals(other$dataprocini)) {
            return false;
        }
        LocalDate this$dataprocinidefault = this.getDataProcInidefault();
        LocalDate other$dataprocinidefault = other.getDataProcInidefault();
        if (this$dataprocinidefault == null ? other$dataprocinidefault != null : !((Object)this$dataprocinidefault).equals(other$dataprocinidefault)) {
            return false;
        }
        LocalDate this$dataprocfim = this.getDataprocfim();
        LocalDate other$dataprocfim = other.getDataprocfim();
        if (this$dataprocfim == null ? other$dataprocfim != null : !((Object)this$dataprocfim).equals(other$dataprocfim)) {
            return false;
        }
        LocalDate this$dataprocfimdefault = this.getDataprocfimdefault();
        LocalDate other$dataprocfimdefault = other.getDataprocfimdefault();
        if (this$dataprocfimdefault == null ? other$dataprocfimdefault != null : !((Object)this$dataprocfimdefault).equals(other$dataprocfimdefault)) {
            return false;
        }
        LocalDate this$datatramiteini = this.getDataTramiteIni();
        LocalDate other$datatramiteini = other.getDataTramiteIni();
        if (this$datatramiteini == null ? other$datatramiteini != null : !((Object)this$datatramiteini).equals(other$datatramiteini)) {
            return false;
        }
        LocalDate this$datatramiteinidefault = this.getDataTramiteInidefault();
        LocalDate other$datatramiteinidefault = other.getDataTramiteInidefault();
        if (this$datatramiteinidefault == null ? other$datatramiteinidefault != null : !((Object)this$datatramiteinidefault).equals(other$datatramiteinidefault)) {
            return false;
        }
        LocalDate this$datatramitefim = this.getDataTramiteFim();
        LocalDate other$datatramitefim = other.getDataTramiteFim();
        if (this$datatramitefim == null ? other$datatramitefim != null : !((Object)this$datatramitefim).equals(other$datatramitefim)) {
            return false;
        }
        LocalDate this$datatramitefimdefault = this.getDataTramiteFimDefault();
        LocalDate other$datatramitefimdefault = other.getDataTramiteFimDefault();
        if (this$datatramitefimdefault == null ? other$datatramitefimdefault != null : !((Object)this$datatramitefimdefault).equals(other$datatramitefimdefault)) {
            return false;
        }
        String this$reportOptions = this.getReportOptions();
        String other$reportOptions = other.getReportOptions();
        return !(this$reportOptions == null ? other$reportOptions != null : !this$reportOptions.equals(other$reportOptions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RelatorioTramiteParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $anoini = this.getAnoIni();
        result = result * 59 + ($anoini == null ? 43 : ((Object)$anoini).hashCode());
        Long $anofim = this.getAnoFim();
        result = result * 59 + ($anofim == null ? 43 : ((Object)$anofim).hashCode());
        Long $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : ((Object)$tipo).hashCode());
        Long $numeroini = this.getNumeroIni();
        result = result * 59 + ($numeroini == null ? 43 : ((Object)$numeroini).hashCode());
        Long $numerofim = this.getNumeroFim();
        result = result * 59 + ($numerofim == null ? 43 : ((Object)$numerofim).hashCode());
        Boolean $exportarExcel = this.getExportarExcel();
        result = result * 59 + ($exportarExcel == null ? 43 : ((Object)$exportarExcel).hashCode());
        Long $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : ((Object)$pessoa).hashCode());
        Long $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : ((Object)$situacao).hashCode());
        Long $assunto = this.getAssunto();
        result = result * 59 + ($assunto == null ? 43 : ((Object)$assunto).hashCode());
        Long $localdestinoini = this.getLocalDestinoIni();
        result = result * 59 + ($localdestinoini == null ? 43 : ((Object)$localdestinoini).hashCode());
        Long $localdestinofim = this.getLocalDestinoFim();
        result = result * 59 + ($localdestinofim == null ? 43 : ((Object)$localdestinofim).hashCode());
        Long $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : ((Object)$lote).hashCode());
        Long $localbase = this.getLocalBase();
        result = result * 59 + ($localbase == null ? 43 : ((Object)$localbase).hashCode());
        String $parecer = this.getParecer();
        result = result * 59 + ($parecer == null ? 43 : $parecer.hashCode());
        LocalDate $dataprocini = this.getDataProcIni();
        result = result * 59 + ($dataprocini == null ? 43 : ((Object)$dataprocini).hashCode());
        LocalDate $dataprocinidefault = this.getDataProcInidefault();
        result = result * 59 + ($dataprocinidefault == null ? 43 : ((Object)$dataprocinidefault).hashCode());
        LocalDate $dataprocfim = this.getDataprocfim();
        result = result * 59 + ($dataprocfim == null ? 43 : ((Object)$dataprocfim).hashCode());
        LocalDate $dataprocfimdefault = this.getDataprocfimdefault();
        result = result * 59 + ($dataprocfimdefault == null ? 43 : ((Object)$dataprocfimdefault).hashCode());
        LocalDate $datatramiteini = this.getDataTramiteIni();
        result = result * 59 + ($datatramiteini == null ? 43 : ((Object)$datatramiteini).hashCode());
        LocalDate $datatramiteinidefault = this.getDataTramiteInidefault();
        result = result * 59 + ($datatramiteinidefault == null ? 43 : ((Object)$datatramiteinidefault).hashCode());
        LocalDate $datatramitefim = this.getDataTramiteFim();
        result = result * 59 + ($datatramitefim == null ? 43 : ((Object)$datatramitefim).hashCode());
        LocalDate $datatramitefimdefault = this.getDataTramiteFimDefault();
        result = result * 59 + ($datatramitefimdefault == null ? 43 : ((Object)$datatramitefimdefault).hashCode());
        String $reportOptions = this.getReportOptions();
        result = result * 59 + ($reportOptions == null ? 43 : $reportOptions.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RelatorioTramiteParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", parecer=" + this.getParecer() + ", anoini=" + this.getAnoIni() + ", anofim=" + this.getAnoFim() + ", tipo=" + this.getTipo() + ", numeroini=" + this.getNumeroIni() + ", numerofim=" + this.getNumeroFim() + ", dataprocini=" + String.valueOf(this.getDataProcIni()) + ", dataprocinidefault=" + String.valueOf(this.getDataProcInidefault()) + ", dataprocfim=" + String.valueOf(this.getDataprocfim()) + ", dataprocfimdefault=" + String.valueOf(this.getDataprocfimdefault()) + ", datatramiteini=" + String.valueOf(this.getDataTramiteIni()) + ", datatramiteinidefault=" + String.valueOf(this.getDataTramiteInidefault()) + ", datatramitefim=" + String.valueOf(this.getDataTramiteFim()) + ", datatramitefimdefault=" + String.valueOf(this.getDataTramiteFimDefault()) + ", exportarExcel=" + this.getExportarExcel() + ", pessoa=" + this.getPessoa() + ", situacao=" + this.getSituacao() + ", assunto=" + this.getAssunto() + ", localdestinoini=" + this.getLocalDestinoIni() + ", localdestinofim=" + this.getLocalDestinoFim() + ", lote=" + this.getLote() + ", localbase=" + this.getLocalBase() + ", reportOptions=" + this.getReportOptions() + ")";
    }

    @Generated
    public RelatorioTramiteParams() {
    }
}

