/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.controller.params;

import java.sql.Date;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class RelatorioProcessoReceberEncaminharParams {
    private static final LocalDate DEFAULT_START_DATE = LocalDate.of(1900, 1, 1);
    private Long entidade;
    private Long tipo;
    private Long numero;
    private Long ano;
    private Long localDestino;
    private LocalDate dataDestino;
    private String nomeRequerente;
    private Boolean exportarExcel = Boolean.FALSE;

    public LocalDate getDataDestinoDefault() {
        return Optional.ofNullable(this.dataDestino).orElse(DEFAULT_START_DATE);
    }

    public MapSqlParameterSource toJdbcParameters() {
        if (Objects.isNull(this.entidade)) {
            throw new IllegalArgumentException("A entidade n\u00e3o pode ser nula");
        }
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)this.getEntidade(), -5);
        params.addValue("tipo", (Object)this.getTipo(), -5);
        params.addValue("numero", (Object)this.getNumero(), -5);
        params.addValue("ano", (Object)this.getAno(), -5);
        params.addValue("localDestino", (Object)this.getLocalDestino(), -5);
        params.addValue("dataDestino", (Object)Date.valueOf(this.getDataDestinoDefault()), 91);
        return params;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getTipo() {
        return this.tipo;
    }

    @Generated
    public Long getNumero() {
        return this.numero;
    }

    @Generated
    public Long getAno() {
        return this.ano;
    }

    @Generated
    public Long getLocalDestino() {
        return this.localDestino;
    }

    @Generated
    public LocalDate getDataDestino() {
        return this.dataDestino;
    }

    @Generated
    public String getNomeRequerente() {
        return this.nomeRequerente;
    }

    @Generated
    public Boolean getExportarExcel() {
        return this.exportarExcel;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setTipo(Long tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Generated
    public void setAno(Long ano) {
        this.ano = ano;
    }

    @Generated
    public void setLocalDestino(Long localDestino) {
        this.localDestino = localDestino;
    }

    @Generated
    public void setDataDestino(LocalDate dataDestino) {
        this.dataDestino = dataDestino;
    }

    @Generated
    public void setNomeRequerente(String nomeRequerente) {
        this.nomeRequerente = nomeRequerente;
    }

    @Generated
    public void setExportarExcel(Boolean exportarExcel) {
        this.exportarExcel = exportarExcel;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelatorioProcessoReceberEncaminharParams)) {
            return false;
        }
        RelatorioProcessoReceberEncaminharParams other = (RelatorioProcessoReceberEncaminharParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$tipo = this.getTipo();
        Long other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !((Object)this$tipo).equals(other$tipo)) {
            return false;
        }
        Long this$numero = this.getNumero();
        Long other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !((Object)this$numero).equals(other$numero)) {
            return false;
        }
        Long this$ano = this.getAno();
        Long other$ano = other.getAno();
        if (this$ano == null ? other$ano != null : !((Object)this$ano).equals(other$ano)) {
            return false;
        }
        Long this$localDestino = this.getLocalDestino();
        Long other$localDestino = other.getLocalDestino();
        if (this$localDestino == null ? other$localDestino != null : !((Object)this$localDestino).equals(other$localDestino)) {
            return false;
        }
        Boolean this$exportarExcel = this.getExportarExcel();
        Boolean other$exportarExcel = other.getExportarExcel();
        if (this$exportarExcel == null ? other$exportarExcel != null : !((Object)this$exportarExcel).equals(other$exportarExcel)) {
            return false;
        }
        LocalDate this$dataDestino = this.getDataDestino();
        LocalDate other$dataDestino = other.getDataDestino();
        if (this$dataDestino == null ? other$dataDestino != null : !((Object)this$dataDestino).equals(other$dataDestino)) {
            return false;
        }
        String this$nomeRequerente = this.getNomeRequerente();
        String other$nomeRequerente = other.getNomeRequerente();
        return !(this$nomeRequerente == null ? other$nomeRequerente != null : !this$nomeRequerente.equals(other$nomeRequerente));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RelatorioProcessoReceberEncaminharParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : ((Object)$tipo).hashCode());
        Long $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : ((Object)$numero).hashCode());
        Long $ano = this.getAno();
        result = result * 59 + ($ano == null ? 43 : ((Object)$ano).hashCode());
        Long $localDestino = this.getLocalDestino();
        result = result * 59 + ($localDestino == null ? 43 : ((Object)$localDestino).hashCode());
        Boolean $exportarExcel = this.getExportarExcel();
        result = result * 59 + ($exportarExcel == null ? 43 : ((Object)$exportarExcel).hashCode());
        LocalDate $dataDestino = this.getDataDestino();
        result = result * 59 + ($dataDestino == null ? 43 : ((Object)$dataDestino).hashCode());
        String $nomeRequerente = this.getNomeRequerente();
        result = result * 59 + ($nomeRequerente == null ? 43 : $nomeRequerente.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RelatorioProcessoReceberEncaminharParams(entidade=" + this.getEntidade() + ", tipo=" + this.getTipo() + ", numero=" + this.getNumero() + ", ano=" + this.getAno() + ", localDestino=" + this.getLocalDestino() + ", dataDestino=" + String.valueOf(this.getDataDestino()) + ", nomeRequerente=" + this.getNomeRequerente() + ", exportarExcel=" + this.getExportarExcel() + ")";
    }

    @Generated
    public RelatorioProcessoReceberEncaminharParams() {
    }
}

