/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.controller.params;

import br.com.elotech.core.utils.DateUtils;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class RelatorioComprovanteEncaminhamentoParams {
    private static final LocalDate DEFAULT_START_DATE = LocalDate.of(1900, 1, 1);
    private static final LocalDate DEFAULT_END_DATE = LocalDate.of(2099, 12, 31);
    private static final LocalDateTime DEFAULT_START_DATETIME = LocalDateTime.of(DEFAULT_START_DATE, LocalTime.of(0, 0));
    private static final LocalDateTime DEFAULT_END_DATETIME = LocalDateTime.of(DEFAULT_END_DATE, LocalTime.of(23, 59));
    public static final String DEFAULT_STRING = "(TODOS)";
    public static final String EMPTY_STRING = "";
    private static final Long DEFAULT_NUMBER = -99L;
    private Long anoprocesso = DEFAULT_NUMBER;
    private Long tipo = DEFAULT_NUMBER;
    private Long numinicioprocesso = DEFAULT_NUMBER;
    private Long numfimprocesso = DEFAULT_NUMBER;
    private LocalDate datainicioprocesso = DEFAULT_START_DATE;
    private LocalDate datafimprocesso = DEFAULT_END_DATE;
    private LocalDate datainiciotramite = DEFAULT_START_DATE;
    private LocalDate datafimtramite = DEFAULT_END_DATE;
    private String horainiciotramite = "";
    private String horafimtramite = "";
    private Boolean requerimento = Boolean.FALSE;
    private Long localdestino = DEFAULT_NUMBER;
    private Long localorigem = DEFAULT_NUMBER;
    private Long lote = DEFAULT_NUMBER;
    private String usuario = "(TODOS)";
    private Long entidade;
    private Long exercicio;
    private Boolean apenasUsuarioLogado = Boolean.FALSE;
    private Long assunto;
    private Long situacao;

    public Long getAnoProcesso() {
        return Optional.ofNullable(this.anoprocesso).orElse(DEFAULT_NUMBER);
    }

    public Long getTipo() {
        return Optional.ofNullable(this.tipo).orElse(DEFAULT_NUMBER);
    }

    public Long getNumInicioProcesso() {
        return Optional.ofNullable(this.numinicioprocesso).orElse(DEFAULT_NUMBER);
    }

    public Long getNumFimProcesso() {
        return Optional.ofNullable(this.numfimprocesso).orElse(DEFAULT_NUMBER);
    }

    public Long getLocalDestino() {
        return Optional.ofNullable(this.localdestino).orElse(DEFAULT_NUMBER);
    }

    public Long getLote() {
        return Optional.ofNullable(this.lote).orElse(DEFAULT_NUMBER);
    }

    public Long getLocalOrigem() {
        return Optional.ofNullable(this.localorigem).orElse(DEFAULT_NUMBER);
    }

    public LocalDate getDataInicioProcesso() {
        return Optional.ofNullable(this.datainicioprocesso).orElse(DEFAULT_START_DATE);
    }

    public LocalDate getDataInicioTramite() {
        return Optional.ofNullable(this.datainiciotramite).orElse(DEFAULT_START_DATE);
    }

    public String getDataInicioTramiteStr() {
        return Optional.ofNullable(this.getDataInicioTramite()).map(DateUtils::formatDateBr).orElse(EMPTY_STRING);
    }

    public LocalDate getDataFimTramite() {
        return Optional.ofNullable(this.datafimtramite).orElse(DEFAULT_END_DATE);
    }

    public String getDataFimTramiteStr() {
        return Optional.ofNullable(this.getDataFimTramite()).map(DateUtils::formatDateBr).orElse(EMPTY_STRING);
    }

    public LocalDate getDataFimProcesso() {
        return Optional.ofNullable(this.datafimprocesso).orElse(DEFAULT_END_DATE);
    }

    public LocalDateTime getHoraInicioTramite() {
        LocalDateTime horaInicioTramite = LocalDateTime.of(this.getDataInicioTramite(), LocalTime.of(this.getHora(this.horainiciotramite, 0), this.getMin(this.horainiciotramite, 0)));
        return Optional.ofNullable(horaInicioTramite).orElse(DEFAULT_START_DATETIME);
    }

    public LocalDateTime getHoraFimTramite() {
        LocalDateTime horaFimTramite = LocalDateTime.of(this.getDataFimTramite(), LocalTime.of(this.getHora(this.horafimtramite, 23), this.getMin(this.horafimtramite, 59)));
        return Optional.ofNullable(horaFimTramite).orElse(DEFAULT_END_DATETIME);
    }

    private int getHora(String value, int hour) {
        if (!value.isEmpty()) {
            hour = Integer.parseInt(value.substring(0, 2));
        }
        return hour;
    }

    private int getMin(String value, int min) {
        if (!value.isEmpty()) {
            min = Integer.parseInt(value.substring(3, 5));
        }
        return min;
    }

    public String getUsuario() {
        return Optional.ofNullable(this.usuario).orElse(DEFAULT_STRING);
    }

    public Boolean getRequerimento() {
        return Boolean.TRUE.equals(this.requerimento);
    }

    public Boolean getApenasUsuarioLogado() {
        return Boolean.TRUE.equals(this.apenasUsuarioLogado);
    }

    public Long getAssunto() {
        return Optional.ofNullable(this.assunto).orElse(DEFAULT_NUMBER);
    }

    public Long getSituacao() {
        return Optional.ofNullable(this.situacao).orElse(DEFAULT_NUMBER);
    }

    public MapSqlParameterSource toJdbcParameters() {
        if (Objects.isNull(this.entidade)) {
            throw new IllegalArgumentException("A entidade n\u00e3o pode ser nula");
        }
        if (this.getApenasUsuarioLogado().booleanValue()) {
            Authentication usuarioAuthentication = SecurityContextHolder.getContext().getAuthentication();
            this.usuario = usuarioAuthentication.getName();
        }
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("anoprocesso", (Object)this.getAnoProcesso(), -5);
        params.addValue("tipo", (Object)this.getTipo(), -5);
        params.addValue("numinicioprocesso", (Object)this.getNumInicioProcesso(), -5);
        params.addValue("numfimprocesso", (Object)this.getNumFimProcesso(), -5);
        params.addValue("localdestino", (Object)this.getLocalDestino(), -5);
        params.addValue("localorigem", (Object)this.getLocalOrigem(), -5);
        params.addValue("lote", (Object)this.getLote(), -5);
        params.addValue("defaultdatainicio", (Object)Date.valueOf(DEFAULT_START_DATE), 91);
        params.addValue("defaultdatafim", (Object)Date.valueOf(DEFAULT_END_DATE), 91);
        params.addValue("datainicioprocesso", (Object)Date.valueOf(this.getDataInicioProcesso()), 91);
        params.addValue("datafimprocesso", (Object)Date.valueOf(this.getDataFimProcesso()), 91);
        params.addValue("datainiciotramite", (Object)Date.valueOf(this.getDataInicioTramite()), 91);
        params.addValue("datainiciotramitestr", (Object)this.getDataInicioTramiteStr(), 12);
        params.addValue("datafimtramite", (Object)Date.valueOf(this.getDataFimTramite()), 91);
        params.addValue("datafimtramitestr", (Object)this.getDataFimTramiteStr(), 12);
        params.addValue("requerimento", (Object)this.getRequerimento(), 16);
        params.addValue("horainiciotramite", (Object)Timestamp.valueOf(this.getHoraInicioTramite()), 93);
        params.addValue("horafimtramite", (Object)Timestamp.valueOf(this.getHoraFimTramite()), 93);
        params.addValue("defaulthorainicio", (Object)Timestamp.valueOf(LocalDateTime.of(DEFAULT_START_DATE, LocalTime.of(0, 0))), 93);
        params.addValue("defaulthorafim", (Object)Timestamp.valueOf(LocalDateTime.of(DEFAULT_END_DATE, LocalTime.of(0, 0))), 93);
        params.addValue("entidade", (Object)this.entidade, -5);
        params.addValue("exercicio", (Object)this.exercicio, -5);
        params.addValue("usuario", (Object)this.getUsuario(), 12);
        params.addValue("assunto", (Object)this.getAssunto(), -5);
        params.addValue("situacao", (Object)this.getSituacao(), -5);
        return params;
    }

    public String orderBy(String sqlOrderBy) {
        if (this.getLote() != -99L) {
            return sqlOrderBy.concat("ORDER BY a.lote,a.lotesequencia,a.data,a.hora");
        }
        return sqlOrderBy.concat("ORDER BY b.ano, b.tipo, b.numero");
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public void setAnoprocesso(Long anoprocesso) {
        this.anoprocesso = anoprocesso;
    }

    @Generated
    public void setTipo(Long tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setNuminicioprocesso(Long numinicioprocesso) {
        this.numinicioprocesso = numinicioprocesso;
    }

    @Generated
    public void setNumfimprocesso(Long numfimprocesso) {
        this.numfimprocesso = numfimprocesso;
    }

    @Generated
    public void setDatainicioprocesso(LocalDate datainicioprocesso) {
        this.datainicioprocesso = datainicioprocesso;
    }

    @Generated
    public void setDatafimprocesso(LocalDate datafimprocesso) {
        this.datafimprocesso = datafimprocesso;
    }

    @Generated
    public void setDatainiciotramite(LocalDate datainiciotramite) {
        this.datainiciotramite = datainiciotramite;
    }

    @Generated
    public void setDatafimtramite(LocalDate datafimtramite) {
        this.datafimtramite = datafimtramite;
    }

    @Generated
    public void setHorainiciotramite(String horainiciotramite) {
        this.horainiciotramite = horainiciotramite;
    }

    @Generated
    public void setHorafimtramite(String horafimtramite) {
        this.horafimtramite = horafimtramite;
    }

    @Generated
    public void setRequerimento(Boolean requerimento) {
        this.requerimento = requerimento;
    }

    @Generated
    public void setLocaldestino(Long localdestino) {
        this.localdestino = localdestino;
    }

    @Generated
    public void setLocalorigem(Long localorigem) {
        this.localorigem = localorigem;
    }

    @Generated
    public void setLote(Long lote) {
        this.lote = lote;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setApenasUsuarioLogado(Boolean apenasUsuarioLogado) {
        this.apenasUsuarioLogado = apenasUsuarioLogado;
    }

    @Generated
    public void setAssunto(Long assunto) {
        this.assunto = assunto;
    }

    @Generated
    public void setSituacao(Long situacao) {
        this.situacao = situacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelatorioComprovanteEncaminhamentoParams)) {
            return false;
        }
        RelatorioComprovanteEncaminhamentoParams other = (RelatorioComprovanteEncaminhamentoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$anoprocesso = this.getAnoProcesso();
        Long other$anoprocesso = other.getAnoProcesso();
        if (this$anoprocesso == null ? other$anoprocesso != null : !((Object)this$anoprocesso).equals(other$anoprocesso)) {
            return false;
        }
        Long this$tipo = this.getTipo();
        Long other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !((Object)this$tipo).equals(other$tipo)) {
            return false;
        }
        Long this$numinicioprocesso = this.getNumInicioProcesso();
        Long other$numinicioprocesso = other.getNumInicioProcesso();
        if (this$numinicioprocesso == null ? other$numinicioprocesso != null : !((Object)this$numinicioprocesso).equals(other$numinicioprocesso)) {
            return false;
        }
        Long this$numfimprocesso = this.getNumFimProcesso();
        Long other$numfimprocesso = other.getNumFimProcesso();
        if (this$numfimprocesso == null ? other$numfimprocesso != null : !((Object)this$numfimprocesso).equals(other$numfimprocesso)) {
            return false;
        }
        Boolean this$requerimento = this.getRequerimento();
        Boolean other$requerimento = other.getRequerimento();
        if (this$requerimento == null ? other$requerimento != null : !((Object)this$requerimento).equals(other$requerimento)) {
            return false;
        }
        Long this$localdestino = this.getLocalDestino();
        Long other$localdestino = other.getLocalDestino();
        if (this$localdestino == null ? other$localdestino != null : !((Object)this$localdestino).equals(other$localdestino)) {
            return false;
        }
        Long this$localorigem = this.getLocalOrigem();
        Long other$localorigem = other.getLocalOrigem();
        if (this$localorigem == null ? other$localorigem != null : !((Object)this$localorigem).equals(other$localorigem)) {
            return false;
        }
        Long this$lote = this.getLote();
        Long other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !((Object)this$lote).equals(other$lote)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Boolean this$apenasUsuarioLogado = this.getApenasUsuarioLogado();
        Boolean other$apenasUsuarioLogado = other.getApenasUsuarioLogado();
        if (this$apenasUsuarioLogado == null ? other$apenasUsuarioLogado != null : !((Object)this$apenasUsuarioLogado).equals(other$apenasUsuarioLogado)) {
            return false;
        }
        Long this$assunto = this.getAssunto();
        Long other$assunto = other.getAssunto();
        if (this$assunto == null ? other$assunto != null : !((Object)this$assunto).equals(other$assunto)) {
            return false;
        }
        Long this$situacao = this.getSituacao();
        Long other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !((Object)this$situacao).equals(other$situacao)) {
            return false;
        }
        LocalDate this$datainicioprocesso = this.getDataInicioProcesso();
        LocalDate other$datainicioprocesso = other.getDataInicioProcesso();
        if (this$datainicioprocesso == null ? other$datainicioprocesso != null : !((Object)this$datainicioprocesso).equals(other$datainicioprocesso)) {
            return false;
        }
        LocalDate this$datafimprocesso = this.getDataFimProcesso();
        LocalDate other$datafimprocesso = other.getDataFimProcesso();
        if (this$datafimprocesso == null ? other$datafimprocesso != null : !((Object)this$datafimprocesso).equals(other$datafimprocesso)) {
            return false;
        }
        LocalDate this$datainiciotramite = this.getDataInicioTramite();
        LocalDate other$datainiciotramite = other.getDataInicioTramite();
        if (this$datainiciotramite == null ? other$datainiciotramite != null : !((Object)this$datainiciotramite).equals(other$datainiciotramite)) {
            return false;
        }
        LocalDate this$datafimtramite = this.getDataFimTramite();
        LocalDate other$datafimtramite = other.getDataFimTramite();
        if (this$datafimtramite == null ? other$datafimtramite != null : !((Object)this$datafimtramite).equals(other$datafimtramite)) {
            return false;
        }
        LocalDateTime this$horainiciotramite = this.getHoraInicioTramite();
        LocalDateTime other$horainiciotramite = other.getHoraInicioTramite();
        if (this$horainiciotramite == null ? other$horainiciotramite != null : !((Object)this$horainiciotramite).equals(other$horainiciotramite)) {
            return false;
        }
        LocalDateTime this$horafimtramite = this.getHoraFimTramite();
        LocalDateTime other$horafimtramite = other.getHoraFimTramite();
        if (this$horafimtramite == null ? other$horafimtramite != null : !((Object)this$horafimtramite).equals(other$horafimtramite)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        return !(this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RelatorioComprovanteEncaminhamentoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $anoprocesso = this.getAnoProcesso();
        result = result * 59 + ($anoprocesso == null ? 43 : ((Object)$anoprocesso).hashCode());
        Long $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : ((Object)$tipo).hashCode());
        Long $numinicioprocesso = this.getNumInicioProcesso();
        result = result * 59 + ($numinicioprocesso == null ? 43 : ((Object)$numinicioprocesso).hashCode());
        Long $numfimprocesso = this.getNumFimProcesso();
        result = result * 59 + ($numfimprocesso == null ? 43 : ((Object)$numfimprocesso).hashCode());
        Boolean $requerimento = this.getRequerimento();
        result = result * 59 + ($requerimento == null ? 43 : ((Object)$requerimento).hashCode());
        Long $localdestino = this.getLocalDestino();
        result = result * 59 + ($localdestino == null ? 43 : ((Object)$localdestino).hashCode());
        Long $localorigem = this.getLocalOrigem();
        result = result * 59 + ($localorigem == null ? 43 : ((Object)$localorigem).hashCode());
        Long $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : ((Object)$lote).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Boolean $apenasUsuarioLogado = this.getApenasUsuarioLogado();
        result = result * 59 + ($apenasUsuarioLogado == null ? 43 : ((Object)$apenasUsuarioLogado).hashCode());
        Long $assunto = this.getAssunto();
        result = result * 59 + ($assunto == null ? 43 : ((Object)$assunto).hashCode());
        Long $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : ((Object)$situacao).hashCode());
        LocalDate $datainicioprocesso = this.getDataInicioProcesso();
        result = result * 59 + ($datainicioprocesso == null ? 43 : ((Object)$datainicioprocesso).hashCode());
        LocalDate $datafimprocesso = this.getDataFimProcesso();
        result = result * 59 + ($datafimprocesso == null ? 43 : ((Object)$datafimprocesso).hashCode());
        LocalDate $datainiciotramite = this.getDataInicioTramite();
        result = result * 59 + ($datainiciotramite == null ? 43 : ((Object)$datainiciotramite).hashCode());
        LocalDate $datafimtramite = this.getDataFimTramite();
        result = result * 59 + ($datafimtramite == null ? 43 : ((Object)$datafimtramite).hashCode());
        LocalDateTime $horainiciotramite = this.getHoraInicioTramite();
        result = result * 59 + ($horainiciotramite == null ? 43 : ((Object)$horainiciotramite).hashCode());
        LocalDateTime $horafimtramite = this.getHoraFimTramite();
        result = result * 59 + ($horafimtramite == null ? 43 : ((Object)$horafimtramite).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RelatorioComprovanteEncaminhamentoParams(anoprocesso=" + this.getAnoProcesso() + ", tipo=" + this.getTipo() + ", numinicioprocesso=" + this.getNumInicioProcesso() + ", numfimprocesso=" + this.getNumFimProcesso() + ", datainicioprocesso=" + String.valueOf(this.getDataInicioProcesso()) + ", datafimprocesso=" + String.valueOf(this.getDataFimProcesso()) + ", datainiciotramite=" + String.valueOf(this.getDataInicioTramite()) + ", datafimtramite=" + String.valueOf(this.getDataFimTramite()) + ", horainiciotramite=" + String.valueOf(this.getHoraInicioTramite()) + ", horafimtramite=" + String.valueOf(this.getHoraFimTramite()) + ", requerimento=" + this.getRequerimento() + ", localdestino=" + this.getLocalDestino() + ", localorigem=" + this.getLocalOrigem() + ", lote=" + this.getLote() + ", usuario=" + this.getUsuario() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", apenasUsuarioLogado=" + this.getApenasUsuarioLogado() + ", assunto=" + this.getAssunto() + ", situacao=" + this.getSituacao() + ")";
    }

    @Generated
    public RelatorioComprovanteEncaminhamentoParams() {
    }
}

