/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.controller;

import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import br.com.elotech.protocolo.service.TramiteRelatorioService;
import br.com.elotech.protocolo.web.controller.params.RelatorioTramiteParams;
import br.com.elotech.protocolo.web.controller.params.RelatorioTramitePorLocalParams;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/api/relatorios/tramite"})
public class TramiteRelatorioController {
    private final TramiteRelatorioService tramiteRelatorioService;

    public TramiteRelatorioController(TramiteRelatorioService tramiteRelatorioService) {
        this.tramiteRelatorioService = tramiteRelatorioService;
    }

    @PostMapping(value={"/detalhado"})
    public void imprimirTramite(@RequestBody RelatorioTramiteParams params, @RequestHeader(value="exercicio") Long exercicio, HttpServletResponse response) throws IOException {
        params.setEntidade(RequestHeaderHelper.getEntidadeLogada());
        params.setExercicio(exercicio);
        byte[] tramite = this.tramiteRelatorioService.createTramiteGeralPdfReport(params);
        if (Objects.nonNull(params.getExportarExcel()) && Boolean.TRUE.equals(params.getExportarExcel())) {
            ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])tramite, (String)RelatorioProtocolo.TRAMITE.getNomeCsv());
        } else {
            ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])tramite, (String)RelatorioProtocolo.TRAMITE.getNomePdf());
        }
    }

    @PostMapping(value={"/tramite-por-local"})
    public void imprimirTramitePorLocal(@RequestBody RelatorioTramitePorLocalParams params, @RequestHeader(value="exercicio") Long exercicio, HttpServletResponse response) throws IOException {
        params.setEntidade(RequestHeaderHelper.getEntidadeLogada());
        params.setExercicio(exercicio);
        byte[] tramite = this.tramiteRelatorioService.createTramitePorLocalReport(params);
        if (Objects.nonNull(params.getExportarExcel()) && Boolean.TRUE.equals(params.getExportarExcel())) {
            ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])tramite, (String)RelatorioProtocolo.TRAMITE_POR_LOCAL.getNomeCsv());
        } else {
            ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])tramite, (String)RelatorioProtocolo.TRAMITE_POR_LOCAL.getNomePdf());
        }
    }
}

