/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.controller;

import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import br.com.elotech.protocolo.service.RelatorioProcessoReceberEncaminharService;
import br.com.elotech.protocolo.web.controller.params.RelatorioProcessoReceberEncaminharParams;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/relatorios/processos"})
public class RelatorioProcessoReceberEncaminharController {
    private final RelatorioProcessoReceberEncaminharService service;

    public RelatorioProcessoReceberEncaminharController(RelatorioProcessoReceberEncaminharService service) {
        this.service = service;
    }

    @PostMapping(value={"/processo-receber-encaminhar"})
    public void imprimirProcessoReceberEncaminhar(@RequestBody RelatorioProcessoReceberEncaminharParams params, HttpServletResponse response) throws IOException {
        params.setEntidade(RequestHeaderHelper.getEntidadeLogada());
        byte[] relatorio = this.service.createProcessoReceberEncaminharReport(params);
        if (Objects.nonNull(params.getExportarExcel()) && Boolean.TRUE.equals(params.getExportarExcel())) {
            ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])relatorio, (String)RelatorioProtocolo.PROCESSO_RECEBER_ENCAMINHAR.getNomeCsv());
        } else {
            ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])relatorio, (String)RelatorioProtocolo.PROCESSO_RECEBER_ENCAMINHAR.getNomePdf());
        }
    }
}

