/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.controller;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.core.utils.web.HeaderUtil;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.dto.params.PesquisaTramiteParams;
import br.com.elotech.protocolo.enums.TipoPapeletaProcessoEnum;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.service.EstatisticasReportService;
import br.com.elotech.protocolo.service.ProcessoRelatorioService;
import br.com.elotech.protocolo.web.controller.params.RelatorioEstatisticasProcessoParams;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/processos/relatorios"})
public class ProcessoRelatorioController {
    private final ProcessoRepository processoRepository;
    private final ProcessoRelatorioService processoRelatorioService;
    private final EstatisticasReportService estatisticasReportService;

    public ProcessoRelatorioController(ProcessoRepository processoRepository, ProcessoRelatorioService processoRelatorioService, EstatisticasReportService estatisticasReportService) {
        this.processoRepository = processoRepository;
        this.processoRelatorioService = processoRelatorioService;
        this.estatisticasReportService = estatisticasReportService;
    }

    @GetMapping(value={"/comprovante"})
    public void imprimirComprovanteProcesso(@RequestParam(value="tipo") Long tipo, @RequestParam(value="numero") Long numero, @RequestParam(value="ano") Long ano, @RequestParam(value="entidade") Long entidade, HttpServletResponse response) throws IOException {
        PesquisaProcessoParams params = new PesquisaProcessoParams(tipo, ano, numero, entidade);
        byte[] comprovanteProcesso = this.processoRelatorioService.createComprovantePdfReport(this.loadProcesso(params));
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])comprovanteProcesso, (String)RelatorioProtocolo.COMPROVANTE_PROCESSO.getNomePdf());
    }

    @GetMapping(value={"/capa"})
    public void imprimirCapaProcesso(@RequestParam(value="tipo") Long tipo, @RequestParam(value="numero") Long numero, @RequestParam(value="ano") Long ano, @RequestParam(value="entidade") Long entidade, HttpServletResponse response) throws IOException {
        PesquisaProcessoParams params = new PesquisaProcessoParams(tipo, ano, numero, entidade);
        byte[] capaProcesso = this.processoRelatorioService.createCapaPdfReport(this.loadProcesso(params), false);
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])capaProcesso, (String)RelatorioProtocolo.CAPA_PROCESSO.getNomePdf());
    }

    @RequestMapping(value={"/visualizacao"}, method={RequestMethod.GET}, params={"tipo", "numero", "ano", "entidade"})
    public void imprimirVisualizacaoProcesso(PesquisaProcessoParams params, HttpServletResponse response) throws IOException {
        byte[] capaProcesso = this.processoRelatorioService.createVisualizacaoPdfReport(this.loadProcesso(params));
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])capaProcesso, (String)RelatorioProtocolo.VISUALIZACAO_PROCESSO.getNomePdf());
    }

    @RequestMapping(value={"/requerimento"}, method={RequestMethod.GET}, params={"tipo", "numero", "ano", "entidade"})
    public void imprimirRequerimentoProcesso(PesquisaProcessoParams params, HttpServletResponse response) throws IOException {
        byte[] requerimento = this.processoRelatorioService.createRequerimentoPdfReport(params);
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])requerimento, (String)RelatorioProtocolo.REQUERIMENTO_PROCESSO.getNomePdf());
    }

    @RequestMapping(value={"/papeleta/{tipo}"}, method={RequestMethod.POST})
    public void imprimirPapeletaTramite(@RequestBody List<PesquisaTramiteParams> params, HttpServletResponse response, @PathVariable(name="tipo", required=false) TipoPapeletaProcessoEnum tipo) throws IOException {
        ArrayList tramites = new ArrayList();
        params.forEach(param -> tramites.add(this.loadTramite(param)));
        Optional param2 = params.stream().findFirst();
        Long entidade = param2.map(PesquisaTramiteParams::getEntidade).orElseGet(RequestHeaderHelper::getEntidadeLogada);
        Long exercicio = param2.map(PesquisaTramiteParams::getAno).orElseGet(() -> (long)ContextHolder.getHeaderValueExercicio());
        byte[] papeleta = this.processoRelatorioService.createPapeletaPdfReport(tramites, tipo, entidade, exercicio);
        String nome = RelatorioProtocolo.PAPELETA_PROCESSO.getNomePdf();
        if (TipoPapeletaProcessoEnum.LOTE.equals((Object)tipo)) {
            nome = RelatorioProtocolo.PAPELETA_PROCESSO_LOTE.getNomePdf();
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])papeleta, (String)nome);
    }

    @PostMapping(value={"/estatisticas/impressao/pdf"}, produces={"application/octet-stream"})
    public void imprimirEstatisticas(@RequestBody RelatorioEstatisticasProcessoParams params, HttpServletResponse response) throws IOException {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        params.setIdEntidade(entidade.getId());
        byte[] arquivoImpressao = this.estatisticasReportService.impressaoEstatisticas(params);
        HeaderUtil.addPdfHeadersToResponse((HttpServletResponse)response, (String)"estatisticas.pdf");
        response.getOutputStream().write(arquivoImpressao);
        response.setContentLength(arquivoImpressao.length);
    }

    private Processo loadProcesso(PesquisaProcessoParams params) {
        if (Objects.isNull(params.getEntidade())) {
            return this.processoRepository.findOneByIdAnoAndIdTipoIdAndIdNumeroAndIdEntidadeId(params.getAno(), params.getTipo(), params.getNumero(), RequestHeaderHelper.getEntidadeLogada());
        }
        return this.processoRepository.findOneByIdAnoAndIdTipoIdAndIdNumeroAndIdEntidadeId(params.getAno(), params.getTipo(), params.getNumero(), params.getEntidade());
    }

    private Tramite loadTramite(PesquisaTramiteParams params) {
        Processo processo = this.loadProcesso(new PesquisaProcessoParams(params.getTipo(), params.getAno(), Long.valueOf(NumberUtils.toLong((String)params.getNumero())), params.getEntidade()));
        if (processo == null) {
            throw RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar o processo %s", params));
        }
        if (params.getSequencia() > 0L) {
            return (Tramite)processo.findBySequencia(params.getSequencia()).orElseThrow(() -> {
                throw RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar o processo %s pela sequ\u00eancia %s", params.getNumero(), params.getSequencia()));
            });
        }
        return processo.getUltimoTramiteByFuncao(Funcao.ENCAMINHADO);
    }
}

