/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.controller;

import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import br.com.elotech.protocolo.service.ProcessoGeralRelatorioService;
import br.com.elotech.protocolo.web.controller.params.RelatorioProcessoParams;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/api/relatorios/processos"})
public class ProcessoGeralRelatorioController {
    private final ProcessoGeralRelatorioService processoGeralRelatorioService;

    public ProcessoGeralRelatorioController(ProcessoGeralRelatorioService processoGeralRelatorioService) {
        this.processoGeralRelatorioService = processoGeralRelatorioService;
    }

    @PostMapping(value={"/geral"})
    public void imprimirProcesso(@RequestBody RelatorioProcessoParams params, @RequestHeader(value="exercicio") Long exercicio, HttpServletResponse response) throws IOException {
        params.setExercicio(exercicio);
        params.setEntidade(RequestHeaderHelper.getEntidadeLogada());
        byte[] processoGeral = this.processoGeralRelatorioService.createProcessoGeralPdfReport(params);
        if (Objects.nonNull(params.getExportarExcel()) && Boolean.TRUE.equals(params.getExportarExcel())) {
            ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])processoGeral, (String)RelatorioProtocolo.PROCESSOS_GERAL.getNomeCsv());
        } else {
            ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])processoGeral, (String)RelatorioProtocolo.PROCESSOS_GERAL.getNomePdf());
        }
    }
}

