/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.controller;

import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import br.com.elotech.protocolo.service.ProcessoEtiquetaRelatorioService;
import br.com.elotech.protocolo.web.controller.params.RelatorioEtiquetaParams;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/api/relatorios/processos"})
public class ProcessoEtiquetaRelatorioController {
    private final ProcessoEtiquetaRelatorioService processoEtiquetaRelatorioService;

    public ProcessoEtiquetaRelatorioController(ProcessoEtiquetaRelatorioService processoEtiquetaRelatorioService) {
        this.processoEtiquetaRelatorioService = processoEtiquetaRelatorioService;
    }

    @PostMapping(value={"/etiqueta"})
    public void imprimirProcesso(@RequestBody RelatorioEtiquetaParams params, @RequestHeader(value="exercicio") Long exercicio, HttpServletResponse response) throws IOException {
        params.setEntidade(RequestHeaderHelper.getEntidadeLogada());
        params.setExercicio(exercicio);
        byte[] processoEtiqueta = this.processoEtiquetaRelatorioService.createProcessoEtiquetaPdfReport(params);
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])processoEtiqueta, (String)RelatorioProtocolo.ETIQUETA.getNomePdf());
    }
}

