/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.controller;

import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import br.com.elotech.protocolo.service.ComprovanteEncaminhamentoProcessoRelatorioService;
import br.com.elotech.protocolo.web.controller.params.RelatorioComprovanteEncaminhamentoParams;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/api/relatorios/processos"})
public class ComprovanteEncaminhamentoProcessoRelatorioController {
    private final ComprovanteEncaminhamentoProcessoRelatorioService comprovanteEncaminhamentoService;

    public ComprovanteEncaminhamentoProcessoRelatorioController(ComprovanteEncaminhamentoProcessoRelatorioService comprovanteEncaminhamentoService) {
        this.comprovanteEncaminhamentoService = comprovanteEncaminhamentoService;
    }

    @PostMapping(value={"/comprovante-encaminhamento"})
    public void imprimirComprovanteEncaminhamentoProcesso(@RequestBody RelatorioComprovanteEncaminhamentoParams params, @RequestHeader(value="exercicio") Long exercicio, HttpServletResponse response) throws IOException {
        params.setEntidade(RequestHeaderHelper.getEntidadeLogada());
        params.setExercicio(exercicio);
        byte[] comprovanteEmcaminhamento = this.comprovanteEncaminhamentoService.createComprovanteEncaminhamentoPdfReport(params);
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])comprovanteEmcaminhamento, (String)RelatorioProtocolo.COMPROVANTE_ENCAMINHAMENTO_PROCESSO.getNomePdf());
    }
}

