/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.controller;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import br.com.elotech.protocolo.service.AssuntoArquivoService;
import br.com.elotech.protocolo.service.AssuntoService;
import br.com.elotech.unico.client.dto.EloArquivoDTO;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/api/arquivos/assuntos"})
public class AssuntoArquivoResource {
    private final AssuntoArquivoService assuntoArquivoService;
    private final AssuntoService assuntoService;

    public AssuntoArquivoResource(AssuntoArquivoService assuntoArquivoService, AssuntoService assuntoService) {
        this.assuntoArquivoService = assuntoArquivoService;
        this.assuntoService = assuntoService;
    }

    @GetMapping(value={"/{idArquivo}/download"})
    public void downloadArquivo(@PathVariable(value="idArquivo") Long idArquivo, HttpServletResponse response) throws IOException {
        Optional arquivoDTO = this.assuntoArquivoService.downloadArquivo(idArquivo);
        if (arquivoDTO.isPresent()) {
            byte[] arquivo = Optional.ofNullable(((EloArquivoDTO)arquivoDTO.get()).getContent().getBinary()).orElseThrow(() -> RestException.notFound((String)String.format("O arquivo com chave %s n\u00e3o tem conte\u00fado ou est\u00e1 inv\u00e1lido", idArquivo)));
            response.setContentType("application/download");
            ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)((EloArquivoDTO)arquivoDTO.get()).getNome());
        }
    }

    @DeleteMapping(value={"/{idArquivo}/{idAssunto}"}, produces={"application/json"})
    public ResponseEntity<Void> deleteArquivoProcesso(@PathVariable(value="idArquivo") Long idArquivo, @PathVariable(value="idAssunto") Long idAssunto) {
        this.assuntoService.removerAssuntoArquivo(idAssunto, idArquivo);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{idAssunto}"})
    public ResponseEntity<AssuntoDTO> addArquivo(@RequestParam(value="files") MultipartFile file, @PathVariable(name="idAssunto") Long idAssunto) {
        Assunto assunto = (Assunto)this.assuntoService.findById((Serializable)idAssunto).orElseThrow(() -> RestException.notFound((String)"Assunto n\u00e3o localizado."));
        return ResponseEntity.ok((Object)this.assuntoArquivoService.addArquivo(assunto, file));
    }
}

