/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.controller;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.dto.ArquivoAtualizarNomeDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.repository.ProcessoArquivoRepository;
import br.com.elotech.protocolo.service.ProcessoArquivoService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.ProcessoService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import br.com.elotech.unico.client.dto.EloArquivoDTO;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/arquivos"})
public class ArquivoResource {
    public static final String ARQUIVO_NAO_ENCONTRADO_MSG = "    Arquivo n\u00e3o encontrado na entidade atual!\n    Para excluir arquivos de processos de outras entidades,\n    \u00e9 necess\u00e1rio fazer login na entidade referente ao processo.\n";
    private final ProcessoArquivoService processoArquivoService;
    private final ProcessoArquivoRepository processoArquivoRepository;
    private final ProcessoPesquisaService processoPesquisaService;
    private final ProcessoService processoService;

    public ArquivoResource(ProcessoArquivoService processoarquivoService, ProcessoArquivoRepository processoArquivoRepository, ProcessoService processoService, ProcessoPesquisaService processoPesquisaService) {
        this.processoArquivoService = processoarquivoService;
        this.processoArquivoRepository = processoArquivoRepository;
        this.processoService = processoService;
        this.processoPesquisaService = processoPesquisaService;
    }

    @GetMapping(value={"/cloud/url/download"})
    public ResponseEntity<ArquivoUrl> getUrlDownload(@RequestParam(value="fullPath") String fullPath, @RequestParam(value="fileName") String fileName) {
        return ResponseEntity.ok((Object)this.processoArquivoService.getUrlDownload(fullPath, fileName));
    }

    @GetMapping(value={"/cloud/url/upload"})
    public ResponseEntity<ArquivoUrl> getUrlUpload(@RequestParam(value="fileName") String fileName, @RequestParam(value="contentType", required=false) String contentType) {
        return ResponseEntity.ok((Object)this.processoArquivoService.getUrlUpload(fileName, contentType));
    }

    @Transactional
    @RequestMapping(value={"/{identificador}/download"}, method={RequestMethod.GET})
    public void downloadArquivo(@PathVariable(value="identificador") String identificador, HttpServletResponse response) throws IOException {
        ProcessoArquivo processoArquivo = Optional.ofNullable(this.processoArquivoRepository.findByIdentificador(identificador)).orElseThrow(() -> RestException.notFound((String)String.format("O arquivo com chave %s n\u00e3o foi encontrado", identificador)));
        Optional arquivoDTO = this.processoArquivoService.downloadArquivo(processoArquivo);
        if (arquivoDTO.isPresent()) {
            byte[] arquivo = Optional.ofNullable(((EloArquivoDTO)arquivoDTO.get()).getContent().getBinary()).orElseThrow(() -> RestException.notFound((String)String.format("O arquivo com chave %s n\u00e3o tem conte\u00fado ou est\u00e1 inv\u00e1lido", identificador)));
            response.setContentType("application/download");
            ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)((EloArquivoDTO)arquivoDTO.get()).getNome());
        }
    }

    @Transactional
    @RequestMapping(value={"/{identificador}/valida"}, method={RequestMethod.GET})
    public ResponseEntity<Void> validaArquivo(@PathVariable(value="identificador") String identificador, HttpServletResponse response) throws IOException {
        Optional.ofNullable(this.processoArquivoRepository.findByIdentificador(identificador)).orElseThrow(() -> RestException.notFound((String)String.format("O arquivo com chave %s n\u00e3o foi encontrado", identificador)));
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{idArquivo}"}, params={"tipo", "numero", "ano"}, produces={"application/json"})
    public ResponseEntity<Void> deleteArquivoProcesso(PesquisaProcessoParams params, @PathVariable(value="idArquivo") String identificadorArquivo) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        Processo processo = this.processoPesquisaService.loadProcesso(entidade, params.getTipo(), params.getNumero(), params.getAno());
        ProcessoArquivo arquivo = (ProcessoArquivo)processo.buscarArquivoPorIdentificador(identificadorArquivo).orElseThrow(() -> new RestException(HttpStatus.BAD_REQUEST, ARQUIVO_NAO_ENCONTRADO_MSG));
        this.processoService.validaPermissoesExclusaoArquivoProcesso(processo, arquivo, auth.getName());
        processo.getArquivos().remove(arquivo);
        this.processoService.save(processo, null);
        this.processoArquivoService.deletarArquivo(arquivo);
        return ResponseEntity.ok().build();
    }

    @Transactional
    @PutMapping(value={"/arquivo-editar-nome"})
    public ResponseEntity<ProcessoArquivo> updateNomeArquivo(@RequestBody ArquivoAtualizarNomeDTO arquivoAtualizarNomeDTO) {
        return ResponseEntity.ok((Object)((ProcessoArquivo)this.processoArquivoRepository.saveAndFlush((Object)this.processoArquivoService.atualizarNomeArquivo(arquivoAtualizarNomeDTO))));
    }
}

