/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.validator;

import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.service.ExercicioService;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessoOuvidoriaValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoOuvidoriaValidator.class);
    private final ExercicioService exercicioService;

    public ProcessoOuvidoriaValidator(ExercicioService exercicioService) {
        this.exercicioService = exercicioService;
    }

    public void validar(Processo processo) {
        this.exercicioService.getExercicioPadraoEntidade(processo.getId().getEntidade());
        if (Objects.isNull(processo.getLocalOrigem())) {
            log.error(String.format("O par\u00e2metro referente ao Local origem da ouvidoria est\u00e1 incorreto, pois, n\u00e3o encontrou nenhum local cadastrado para entidade %s", processo.getId().getEntidade().getNome()));
            throw new RegistroNaoEncontradoException("Local Origem n\u00e3o localizada, configure corretamente o valor do par\u00e2metro");
        }
        if (Objects.isNull(processo.getLocalDestino())) {
            log.error(String.format("O par\u00e2metro referente ao Local destino da ouvidoria est\u00e1 incorreto, pois, n\u00e3o encontrou nenhum local cadastrado para entidade %s e assunto %s", processo.getId().getEntidade().getNome(), processo.getAssunto().getDescricao()));
            throw new RegistroNaoEncontradoException("Local Destino n\u00e3o localizada, configure corretamente o valor do par\u00e2metro");
        }
    }
}

