/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.utils;

import br.com.elotech.domain.PDFonts;
import br.com.elotech.protocolo.exception.AssinadorDigitalException;
import br.com.elotech.protocolo.exception.PDFPrecisaPosicionar;
import br.com.elotech.utils.pdf.sign.PdfSignerUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PdfUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfUtils.class);

    public static byte[] addBlankPageAndPrepareToPdf(byte[] pdf, String urlQrcode, String identificador) throws IOException, PDFPrecisaPosicionar {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (PDDocument document = Loader.loadPDF((byte[])pdf);){
            if (PdfUtils.pdfHasSignatures((PDDocument)document)) {
                throw new PDFPrecisaPosicionar("O arquivo PDF j\u00e1 possui assinaturas. N\u00e3o \u00e9 poss\u00edvel adicionar a nova p\u00e1gina para assinaturas. Assine o arquivo manualmente ou tente novamente.");
            }
            PDPage newPage = new PDPage(document.getPage(0).getMediaBox());
            document.addPage(newPage);
            int lastPageNumber = document.getNumberOfPages();
            if (StringUtils.isNotBlank((CharSequence)urlQrcode)) {
                PdfUtils.addQRCode((PDDocument)document, (String)urlQrcode, (int)(lastPageNumber - 1));
            }
            PdfUtils.addFooter((PDDocument)document, (String)identificador);
            document.save((OutputStream)output);
        }
        return output.toByteArray();
    }

    public static Integer getNumberOfPages(byte[] pdf) {
        Integer n;
        block8: {
            PDDocument document = Loader.loadPDF((byte[])pdf);
            try {
                n = document.getNumberOfPages();
                if (document == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Falha ao carregar PDF", (Throwable)e);
                    throw new AssinadorDigitalException("PDF Inv\u00e1lido", e);
                }
            }
            document.close();
        }
        return n;
    }

    public static boolean pdfHasSignatures(byte[] pdf) {
        boolean bl;
        block8: {
            PDDocument document = Loader.loadPDF((byte[])pdf);
            try {
                bl = PdfUtils.pdfHasSignatures((PDDocument)document);
                if (document == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Falha ao carregar PDF", (Throwable)e);
                    throw new AssinadorDigitalException("PDF Inv\u00e1lido", e);
                }
            }
            document.close();
        }
        return bl;
    }

    private static boolean pdfHasSignatures(PDDocument document) {
        try {
            return Objects.nonNull(document.getSignatureDictionaries()) && !document.getSignatureDictionaries().isEmpty();
        }
        catch (Exception e) {
            log.warn("Falha ao verificar se o PDF possui assinaturas: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static void addFooter(PDDocument document, String identificador) throws IOException {
        int totalPages = document.getNumberOfPages();
        for (int i = 0; i < totalPages; ++i) {
            PDPage page = document.getPage(i);
            PDRectangle pageSize = page.getMediaBox();
            float x = pageSize.getLowerLeftX() + 24.0f;
            float y = pageSize.getLowerLeftY() + 14.0f;
            String footerText = String.format("Assinatura eletr\u00f4nica - Identificador: %s - P\u00e1gina %d / %d", identificador, i + 1, totalPages);
            try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true);){
                contentStream.beginText();
                contentStream.setFont(PDFonts.HELVETICA.getFont(), 8.0f);
                contentStream.newLineAtOffset(x, y);
                contentStream.showText(footerText);
                contentStream.endText();
                continue;
            }
        }
    }

    private static void addQRCode(PDDocument document, String text, int pageIndex) throws IOException {
        PDPage page = document.getPage(pageIndex);
        PDRectangle mediaBox = page.getMediaBox();
        float pageWidth = mediaBox.getWidth();
        float pageHeight = mediaBox.getHeight();
        int qrCodeSize = 90;
        float x = (pageWidth - 90.0f) / 2.0f;
        float y = pageHeight - 120.0f;
        BufferedImage qrImage = PdfUtils.generateQRCodeImage((String)text, (int)90);
        PDImageXObject pdImage = LosslessFactory.createFromImage((PDDocument)document, (BufferedImage)qrImage);
        try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true);){
            contentStream.drawImage(pdImage, x, y, 90.0f, 90.0f);
            contentStream.beginText();
            PdfUtils.showCenteredText((PDPageContentStream)contentStream, (float)pageWidth, (float)(pageHeight - 20.0f), (String)"Consulte autenticidade do arquivo atrav\u00e9s do QR Code, ou copie e cole o link no navegador:");
            contentStream.endText();
            contentStream.beginText();
            contentStream.setNonStrokingColor(Color.BLUE);
            float linkWidth = PdfUtils.showCenteredText((PDPageContentStream)contentStream, (float)pageWidth, (float)(pageHeight - 28.0f), (String)text);
            contentStream.endText();
            contentStream.setStrokingColor(Color.BLUE);
            contentStream.moveTo((pageWidth - linkWidth) / 2.0f, pageHeight - 30.0f);
            contentStream.lineTo((pageWidth + linkWidth) / 2.0f, pageHeight - 30.0f);
            contentStream.stroke();
        }
    }

    private static float showCenteredText(PDPageContentStream contentStream, float pageWidth, float y, String text) throws IOException {
        PDFont font = PDFonts.HELVETICA.getFont();
        float fontSize = 8.0f;
        float textWidth = font.getStringWidth(text) / 1000.0f * fontSize;
        float x = (pageWidth - textWidth) / 2.0f;
        contentStream.setFont(font, fontSize);
        contentStream.newLineAtOffset(x, y);
        contentStream.showText(text);
        return textWidth;
    }

    public static PDImageXObject generateQRCodePdImage(PDDocument doc, String text, int length) throws IOException {
        BufferedImage qrImage = PdfUtils.generateQRCodeImage((String)text, (int)length);
        return LosslessFactory.createFromImage((PDDocument)doc, (BufferedImage)qrImage);
    }

    public static BufferedImage generateQRCodeImage(String text, int length) {
        try {
            HashMap<EncodeHintType, Integer> hintMap = new HashMap<EncodeHintType, Integer>();
            hintMap.put(EncodeHintType.MARGIN, 0);
            BitMatrix matrix = new MultiFormatWriter().encode(new String(text.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8), BarcodeFormat.QR_CODE, length, length, hintMap);
            return MatrixToImageWriter.toBufferedImage((BitMatrix)matrix);
        }
        catch (WriterException e) {
            throw new AssinadorDigitalException("Falha ao gerar QRCode: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public static String extractPdfText(PDDocument doc) {
        try {
            PDFTextStripper stripper = new PDFTextStripper();
            StringBuilder sb = new StringBuilder(stripper.getText(doc));
            PdfUtils.appendAnnotationText((PDDocument)doc, (StringBuilder)sb);
            return sb.toString();
        }
        catch (IOException e) {
            log.warn("Falha ao extrair texto do PDF: ".concat(e.getLocalizedMessage()), (Throwable)e);
            return "";
        }
    }

    private static void appendAnnotationText(PDDocument doc, StringBuilder sb) throws IOException {
        for (PDPage page : doc.getPages()) {
            for (PDAnnotation annotation : page.getAnnotations()) {
                Optional.ofNullable(annotation.getContents()).filter(StringUtils::isNotBlank).ifPresent(sb::append);
                Optional<PDAppearanceStream> appearanceStream = Optional.ofNullable(annotation.getAppearance()).map(PDAppearanceDictionary::getNormalAppearance).map(PDAppearanceEntry::getAppearanceStream);
                if (!appearanceStream.isPresent()) continue;
                sb.append(PdfUtils.extrairTextoDeAppearanceStream((PDAppearanceStream)appearanceStream.get()));
            }
            sb.append(System.lineSeparator());
        }
    }

    private static String extrairTextoDeAppearanceStream(PDAppearanceStream apStream) throws IOException {
        try (PDDocument fakeDoc = new PDDocument();){
            apStream.setMatrix(new AffineTransform());
            PDPage dummyPage = new PDPage(apStream.getBBox());
            dummyPage.setResources(apStream.getResources());
            dummyPage.setContents(apStream.getContentStream());
            fakeDoc.addPage(dummyPage);
            PDFTextStripper stripper = new PDFTextStripper();
            String string = stripper.getText(fakeDoc);
            return string;
        }
    }

    public static float getTextAsImageWidth(String text, Optional<Integer> fontSize) {
        return Arrays.stream(text.replace("\r", "").replace("\t", "").split("\n")).map(line -> Float.valueOf(PdfSignerUtil.getTextAsImageWidth((String)line, (Optional)fontSize, Optional.empty()))).reduce(Float.valueOf(0.0f), Float::max).floatValue();
    }

    @Generated
    private PdfUtils() {
    }
}

