/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.lang.Nullable;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class ByteMultipartFile
implements MultipartFile {
    private String name;
    private final String originalFilename;
    @Nullable
    private final String contentType;
    private final byte[] content;

    public ByteMultipartFile(@Nullable byte[] content, @Nullable String contentType, String filename) {
        this.name = filename;
        this.originalFilename = filename;
        this.content = content == null ? new byte[]{} : content;
        this.contentType = contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public long getSize() {
        return this.content.length;
    }

    public byte[] getBytes() throws IOException {
        return this.content;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void transferTo(File dest) throws IOException {
        FileCopyUtils.copy((byte[])this.content, (File)dest);
    }

    public void setName(String name) {
        this.name = name;
    }
}

