/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.strategy.impl.tramite;

import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.LocalDTO;
import br.com.elotech.protocolo.dto.TramiteProcessosWrapper;
import br.com.elotech.protocolo.service.util.ProcessoUtils;
import br.com.elotech.protocolo.strategy.TramiteBusinessStrategy;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TramiteRecebimentoStrategy
extends TramiteBusinessStrategy {
    private final ProtocoloMapper mapper;

    public TramiteRecebimentoStrategy(Entidade entidade, ProtocoloMapper mapper) {
        super(entidade);
        this.mapper = mapper;
    }

    public void validar(Processo processo, List<EloViolation> violations, LocalDTO localDTO) {
        if (Funcao.RECEBIDO.equals((Object)processo.getFuncao())) {
            violations.add(new EloViolation(String.format("O processo '%s' j\u00e1 foi recebido", processo.getId())));
        }
        this.throwIfViolation(violations, Funcao.RECEBIDO);
    }

    public Tramite tramitar(Processo processo, TramiteProcessosWrapper tramite, String usuario) {
        Situacao situacao = this.mapper.toSituacao(tramite.getSituacao());
        processo.setSituacao(situacao);
        processo.marcarRecebido();
        processo.setLocalAtual(processo.getLocalDestino());
        processo.setUsuarioResponsavelTramite(null);
        if (Objects.isNull(tramite.getUsuarioEncaminhamento()) && Funcao.RECEBIDO.equals((Object)tramite.getFuncao())) {
            processo.setUsuarioResponsavelTramite(new Usuario(usuario));
        } else if (Objects.nonNull(tramite.getUsuarioEncaminhamento()) && Funcao.ENCAMINHADO.equals((Object)tramite.getFuncao())) {
            processo.setUsuarioResponsavelTramite(new Usuario(tramite.getUsuarioEncaminhamento().getLoginUsuario()));
        }
        ProcessoUtils.tramitarCamposProcesso((Processo)processo, (TramiteProcessosWrapper)tramite);
        Optional parecerProcesso = processo.parecerProcessoByTramiteWrapper(tramite);
        Tramite.TramiteBuilder tramiteBuilder = Tramite.novoRecebimento((Processo)processo).comLocal(processo.getLocalDestino()).comParecer(tramite.getParecer()).comUsuario(usuario).comNotaPrivada(tramite.getNotaPrivada()).comLote(tramite.getLote());
        parecerProcesso.ifPresent(arg_0 -> ((Tramite.TramiteBuilder)tramiteBuilder).comParecer(arg_0));
        Optional.ofNullable(tramite.getSituacao()).ifPresent(s -> tramiteBuilder.comSituacao(this.mapper.toSituacao(s)));
        return tramiteBuilder.criar(LocalDate.now());
    }
}

