/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.strategy.impl.tramite;

import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.protocolo.converter.EntidadeDTOConverter;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.RoteiroLocal;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.LocalDTO;
import br.com.elotech.protocolo.dto.TramiteProcessosWrapper;
import br.com.elotech.protocolo.service.util.ProcessoUtils;
import br.com.elotech.protocolo.strategy.TramiteBusinessStrategy;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;

public class TramiteEncaminhamentoStrategy
extends TramiteBusinessStrategy {
    private final ProtocoloMapper mapper;

    public TramiteEncaminhamentoStrategy(Entidade entidade, ProtocoloMapper mapper) {
        super(entidade);
        this.mapper = mapper;
    }

    public void validar(Processo processo, List<EloViolation> violations, LocalDTO localDTO) {
        Local local = this.mapper.toLocal(localDTO);
        if (Funcao.ENCAMINHADO.equals((Object)processo.getFuncao())) {
            violations.add(new EloViolation(String.format("O processo [%s] precisa ser recebido antes de ser encaminhado", processo.getId())));
        }
        if (!(!processo.getAssunto().getControlaTramitacao().booleanValue() || processo.podeSerTramitado().booleanValue() && ((RoteiroLocal)processo.getAssunto().getRoteiro().getRoteirosLocaisOrdenadoPorSequencia().get(processo.buscaIndiceProximoRoteiro())).getLocal().equals((Object)local))) {
            violations.add(new EloViolation(String.format("O processo [%s] n\u00e3o pode ser encaminhado para este local.", processo.getId())));
        }
        this.throwIfViolation(violations, Funcao.ENCAMINHADO);
    }

    public Tramite tramitar(Processo processo, TramiteProcessosWrapper tramite, String usuario) {
        Local local = this.mapper.toLocal(tramite.getLocal());
        Entidade entidadeLocal = new EntidadeDTOConverter().from(tramite.getLocal().getEntidade());
        Situacao situacao = this.mapper.toSituacao(tramite.getSituacao());
        local.getId().setEntidade(entidadeLocal);
        processo.setSituacao(situacao);
        processo.marcarEncaminhado();
        processo.setUsuarioResponsavelTramite(null);
        if (tramite.getUsuarioEncaminhamento() != null) {
            Usuario responsavel = new Usuario();
            responsavel.setId(tramite.getUsuarioEncaminhamento().getLoginUsuario());
            responsavel.setNome(tramite.getUsuarioEncaminhamento().getNomeUsuario());
            processo.setUsuarioResponsavelTramite(responsavel);
        }
        ProcessoUtils.tramitarCamposProcesso((Processo)processo, (TramiteProcessosWrapper)tramite);
        processo.setLocalDestino(local);
        Optional parecerProcesso = processo.parecerProcessoByTramiteWrapper(tramite);
        Tramite.TramiteBuilder tramiteBuilder = Tramite.novoEncaminhamento((Processo)processo).comLocal(local).comParecer(tramite.getParecer()).comParecerResposta(tramite.getParecerResposta()).comDataParecerResposta(tramite.getDataParecerResposta()).comSituacao(situacao).comUsuario(usuario).comLote(tramite.getLote()).comNotaPrivada(tramite.getNotaPrivada()).comUsuarioResponsavelTramite(tramite.getUsuarioEncaminhamento()).comLoteSequencia(tramite.getLoteSequencia());
        parecerProcesso.ifPresent(arg_0 -> ((Tramite.TramiteBuilder)tramiteBuilder).comParecer(arg_0));
        return tramiteBuilder.criar(LocalDate.now());
    }
}

