/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.strategy.impl.tramite;

import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.protocolo.converter.EntidadeDTOConverter;
import br.com.elotech.protocolo.domain.Caixa;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.RoteiroLocal;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.LocalDTO;
import br.com.elotech.protocolo.dto.TramiteProcessosWrapper;
import br.com.elotech.protocolo.enums.AssinaturaSituacaoEnum;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.util.ProcessoUtils;
import br.com.elotech.protocolo.strategy.TramiteBusinessStrategy;
import br.com.elotech.protocolo.strategy.impl.tramite.TramiteRecebimentoStrategy;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;

public class TramiteArquivamentoStrategy
extends TramiteBusinessStrategy {
    private final TramiteRecebimentoStrategy tramiteRecebimentoStrategy;
    protected final ProtocoloMapper mapper;
    private final ParametroService parametroService;

    public TramiteArquivamentoStrategy(Entidade entidade, ProtocoloMapper mapper, ParametroService parametroService) {
        super(entidade);
        this.tramiteRecebimentoStrategy = new TramiteRecebimentoStrategy(entidade, mapper);
        this.mapper = mapper;
        this.parametroService = parametroService;
    }

    public void validar(Processo processo, List<EloViolation> violations, LocalDTO localDestino) {
        boolean possuiAssinaturaPendente;
        Boolean bloqueiaArquivarAssinaturaPendente;
        Integer indiceProximoRoteiro;
        List roteirosLocaisOrdenadoPorSequencia;
        boolean permiteArquivarLocalAtual;
        Local localParaTramitar = this.mapper.toLocal(localDestino);
        if (processo.isArquivado().booleanValue()) {
            violations.add(new EloViolation("O processo j\u00e1 est\u00e1 arquivado!"));
        }
        if (processo.getAssunto().getControlaTramitacao().booleanValue() && !processo.podeSerArquivado().booleanValue()) {
            violations.add(new EloViolation(String.format("O processo [%s] n\u00e3o pode ser arquivado para este local.", processo.getId())));
        }
        if (processo.getAssunto().getControlaTramitacao().booleanValue() && processo.podeSerArquivado().booleanValue() && !(permiteArquivarLocalAtual = RoteiroLocal.permiteArquivamentoProcesso((List)(roteirosLocaisOrdenadoPorSequencia = processo.getAssunto().getRoteiro().getRoteirosLocaisOrdenadoPorSequencia()), (Integer)((indiceProximoRoteiro = processo.buscaIndiceProximoRoteiro()) - 1), (Local)localParaTramitar))) {
            violations.add(new EloViolation(String.format("O processo [%s] n\u00e3o pode ser arquivado para este local.", processo.getId())));
        }
        if (Boolean.TRUE.equals(bloqueiaArquivarAssinaturaPendente = this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_PERMITIR_ARQUIVAMENTO_COM_ASSINATURA_PENDENTE.getCodigo())) && (possuiAssinaturaPendente = processo.getArquivos().stream().anyMatch(arquivo -> arquivo.getAssinaturas().stream().anyMatch(assinatura -> AssinaturaSituacaoEnum.PENDENTE.equals((Object)assinatura.getSituacao()))))) {
            violations.add(new EloViolation("Processo n\u00e3o pode ser arquivado pois possui assinatura pendente"));
        }
        this.throwIfViolation(violations, Funcao.ARQUIVADO);
    }

    public Tramite tramitar(Processo processo, TramiteProcessosWrapper tramite, String usuario) {
        Caixa caixa = this.mapper.toCaixa(tramite.getCaixa());
        Local local = this.mapper.toLocal(tramite.getLocal());
        Entidade entidadeLocal = new EntidadeDTOConverter().from(tramite.getLocal().getEntidade());
        Situacao situacao = this.mapper.toSituacao(tramite.getSituacao());
        local.getId().setEntidade(entidadeLocal);
        processo.setSituacao(situacao);
        processo.marcarArquivado();
        processo.setFechado(tramite.getFechado());
        ProcessoUtils.tramitarCamposProcesso((Processo)processo, (TramiteProcessosWrapper)tramite);
        this.receberAutomaticamente(processo, tramite, usuario);
        processo.setLocalAtual(local);
        Optional parecerProcesso = processo.parecerProcessoByTramiteWrapper(tramite);
        Tramite.TramiteBuilder tramiteBuilder = Tramite.novoArquivamento((Processo)processo).comLocal(local).comUsuario(usuario).comCaixa(caixa).comLote(tramite.getLote()).comLoteSequencia(tramite.getLoteSequencia()).comParecer(tramite.getParecer()).comSituacao(situacao).comNotaPrivada(tramite.getNotaPrivada()).comUsuarioResponsavelTramite(tramite.getUsuarioEncaminhamento());
        parecerProcesso.ifPresent(arg_0 -> ((Tramite.TramiteBuilder)tramiteBuilder).comParecer(arg_0));
        processo.setUsuarioResponsavelTramite(new Usuario(usuario));
        Tramite novoTramite = tramiteBuilder.criar(LocalDate.now());
        novoTramite.setQuantidadeFolhas(tramite.getQuantidadeFolhas());
        return novoTramite;
    }

    protected void receberAutomaticamente(Processo processo, TramiteProcessosWrapper tramiteProcessos, String usuario) {
        Optional ultimoTramite = processo.getUltimoTramite();
        if (!ultimoTramite.isPresent()) {
            return;
        }
        if (Funcao.ENCAMINHADO.equals((Object)((Tramite)ultimoTramite.get()).getFuncao())) {
            TramiteProcessosWrapper tramiteProcessosClone = TramiteProcessosWrapper.copy((TramiteProcessosWrapper)tramiteProcessos);
            tramiteProcessosClone.setParecer("Recebido Automaticamente no Encerramento do Processo");
            this.tramiteRecebimentoStrategy.validar(processo, (List)Lists.newArrayList(), tramiteProcessosClone.getLocal());
            this.tramiteRecebimentoStrategy.tramitar(processo, tramiteProcessosClone, usuario);
        }
    }
}

