/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.strategy.impl.processo;

import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.PessoaService;
import br.com.elotech.protocolo.service.ProcessoArquivoService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.strategy.SalvaProcessoStrategy;
import br.com.elotech.protocolo.strategy.impl.processo.SalvaProcessoAssinaturaStrategy;
import br.com.elotech.protocolo.strategy.impl.processo.SalvaProcessoExternoStrategy;
import br.com.elotech.protocolo.strategy.impl.processo.SalvaProcessoIntegracaoStrategy;
import br.com.elotech.protocolo.strategy.impl.processo.SalvaProcessoOuvidoriaStrategy;

public final class SalvaProcessoStrategyFactory {
    private SalvaProcessoStrategyFactory() {
    }

    public static SalvaProcessoStrategy get(ProcessoDTO processoDto, ProtocoloMapper mapper, EntidadeService entidadeService, ExercicioService exercicioService, ParametroService parametroService, PessoaService pessoaService, ProcessoArquivoService processoArquivoService, UsuarioService usuarioService, Boolean integracao) {
        if (processoDto.isOuvidoria().booleanValue()) {
            return new SalvaProcessoOuvidoriaStrategy(mapper, entidadeService, exercicioService, parametroService, pessoaService);
        }
        if (processoDto.isIntegracaoAssinatura().booleanValue()) {
            return new SalvaProcessoAssinaturaStrategy(mapper, entidadeService, processoArquivoService, usuarioService, parametroService, exercicioService);
        }
        if (Boolean.TRUE.equals(integracao)) {
            return new SalvaProcessoIntegracaoStrategy(mapper, entidadeService, parametroService, exercicioService);
        }
        return new SalvaProcessoExternoStrategy(mapper, entidadeService, parametroService, pessoaService, exercicioService);
    }
}

