/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.strategy.impl.processo;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.PessoaService;
import br.com.elotech.protocolo.strategy.SalvaProcessoStrategy;
import br.com.elotech.protocolo.validator.ProcessoOuvidoriaValidator;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalvaProcessoOuvidoriaStrategy
implements SalvaProcessoStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SalvaProcessoOuvidoriaStrategy.class);
    private static final String USUARIO_DEFAULT_PROCESSO_EXTERNO = "USER_EXTERNO";
    private ProtocoloMapper mapper;
    private EntidadeService entidadeService;
    private ExercicioService exercicioService;
    private ParametroService parametroService;
    private PessoaService pessoaService;

    public Processo criar(ProcessoDTO processoDTO) {
        Long idEntidade = this.parametroService.getParamLongEntidadeProcessoOuvidoria();
        return this.criar(processoDTO, idEntidade);
    }

    public Processo criar(ProcessoDTO processoDTO, Long idEntidade) {
        Entidade entidade = (Entidade)this.entidadeService.findOne((Serializable)idEntidade);
        if (Objects.isNull(entidade)) {
            log.error("O par\u00e2metro referente a Entidade da ouvidoria est\u00e1 incorreto, pois, n\u00e3o encontrou nenhuma entidade com seu valor");
            throw new RegistroNaoEncontradoException("Entidade n\u00e3o localizada, configure corretamente o valor do par\u00e2metro");
        }
        return this.criarProcesso(processoDTO, entidade);
    }

    private Processo criarProcesso(ProcessoDTO processoDto, Entidade entidade) {
        boolean isSigiloso;
        ProcessoOuvidoriaValidator validator = new ProcessoOuvidoriaValidator(this.exercicioService);
        processoDto.setTipo(this.mapper.toTipoProcessoSimpleDTO(this.parametroService.getParamTipoProcessoOuvidoria(entidade)));
        if (processoDto.isOuvidoriaAnonima().booleanValue()) {
            processoDto.setPessoa(this.mapper.toPessoaDTO(this.parametroService.getParamPessoaAnonima(entidade)));
        } else {
            processoDto.setPessoa(this.pessoaService.savePessoaProcessoExterno(processoDto));
        }
        processoDto.setSituacao(this.mapper.toSituacaoDTO(this.parametroService.getParamSituacaoProcessoExterno(entidade)));
        processoDto.setEntidade(this.mapper.toEntidadeDTO(entidade));
        Processo processo = this.mapper.toProcesso(processoDto, new Processo());
        ProcessoPK pkProcesso = ProcessoPK.of((Entidade)entidade, (TipoProcesso)this.mapper.toTipoProcesso(processoDto.getTipo()), null, (Long)Long.valueOf(LocalDate.now().getYear()));
        processo.setId(pkProcesso);
        processo.setExterno(Boolean.FALSE);
        processo.setUuid(UUID.randomUUID().toString());
        if (processo.getUsuarioRegistro() == null) {
            processo.setUsuarioRegistro(USUARIO_DEFAULT_PROCESSO_EXTERNO);
        }
        processo.setLocalOrigem(this.parametroService.getParamLocalOrigemProcessoOuvidoria(entidade));
        processo.setLocalDestino(this.parametroService.getParamLocalDestinoProcessoOuvidoria(entidade, processo.getAssunto()));
        boolean bl = isSigiloso = processo.getAssunto().getSigiloso() != false || processo.getId().getTipo().getSigiloso() != false;
        if (Boolean.FALSE.equals(isSigiloso)) {
            isSigiloso = this.parametroService.getParamValueAsBoolean(ParametroEnum.PADRAO_SIGILOSO_OUVIDORIA.getCodigo(), entidade.getId(), this.exercicioService.getExercicioAtual());
        }
        processo.setSigiloso(Boolean.valueOf(isSigiloso));
        processo.setTipoOuvidoria(processoDto.getTipoOuvidoria());
        processo.setBloqueioAnexoExterno(this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_ANEXOS_CONSULTA_EXTERNA_SEM_LIBERACAO_USUARIO_INTERNO.getCodigo(), entidade.getId(), this.exercicioService.getExercicioAtual()));
        validator.validar(processo);
        return processo;
    }

    @Generated
    public SalvaProcessoOuvidoriaStrategy() {
    }

    @Generated
    public SalvaProcessoOuvidoriaStrategy(ProtocoloMapper mapper, EntidadeService entidadeService, ExercicioService exercicioService, ParametroService parametroService, PessoaService pessoaService) {
        this.mapper = mapper;
        this.entidadeService = entidadeService;
        this.exercicioService = exercicioService;
        this.parametroService = parametroService;
        this.pessoaService = pessoaService;
    }
}

