/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.strategy.impl.processo;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.PessoaService;
import br.com.elotech.protocolo.strategy.SalvaProcessoStrategy;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalvaProcessoExternoStrategy
implements SalvaProcessoStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SalvaProcessoExternoStrategy.class);
    private static final String USUARIO_DEFAULT_PROCESSO_EXTERNO = "USER_EXTERNO";
    private ProtocoloMapper mapper;
    private EntidadeService entidadeService;
    private ParametroService parametroService;
    private PessoaService pessoaService;
    private ExercicioService exercicioService;

    public Processo criar(ProcessoDTO processoDto) {
        Long idEntidade = this.parametroService.getParamLongEntidadeProcessoExterno();
        return this.criar(processoDto, idEntidade);
    }

    public Processo criar(ProcessoDTO processoDTO, Long idEntidade) {
        Entidade entidade = (Entidade)this.entidadeService.findOne((Serializable)idEntidade);
        if (Objects.isNull(entidade)) {
            log.error("O par\u00e2metro referente a Entidade do processo externo est\u00e1 incorreto, pois, n\u00e3o encontrou nenhuma entidade com seu valor");
            throw new RegistroNaoEncontradoException("Entidade n\u00e3o localizada, configure corretamente o valor do par\u00e2metro");
        }
        return this.criarProcesso(processoDTO, entidade);
    }

    private Processo criarProcesso(ProcessoDTO processoDto, Entidade entidade) {
        if (processoDto.isOuvidoriaAnonima().booleanValue()) {
            processoDto.setPessoa(this.mapper.toPessoaDTO(this.parametroService.getParamPessoaAnonima(entidade)));
        } else {
            processoDto.setPessoa(this.pessoaService.savePessoaProcessoExterno(processoDto));
        }
        if (processoDto.getTipo() == null) {
            processoDto.setTipo(this.mapper.toTipoProcessoSimpleDTO(this.parametroService.getParamTipoProcessoExterno(entidade)));
        }
        processoDto.setSituacao(this.mapper.toSituacaoDTO(this.parametroService.getParamSituacaoProcessoExterno(entidade)));
        processoDto.setEntidade(this.mapper.toEntidadeDTO(entidade));
        processoDto.getInteressados().forEach(pi -> pi.setPessoa(this.pessoaService.savePessoaProcessoInteressadoExterno(pi)));
        Processo processo = this.mapper.toProcesso(processoDto, new Processo());
        ProcessoPK pkProcesso = ProcessoPK.of((Entidade)entidade, (TipoProcesso)this.mapper.toTipoProcesso(processoDto.getTipo()), null, (Long)Long.valueOf(LocalDate.now().getYear()));
        processo.setId(pkProcesso);
        processo.setExterno(Boolean.TRUE);
        processo.setPossuiTaxa(processoDto.getAssunto().getPossuiTaxas());
        processo.setUuid(UUID.randomUUID().toString());
        processo.setSigiloso(Boolean.valueOf(processoDto.getAssunto().getSigiloso() != false || processoDto.getTipo().getSigiloso() != false));
        if (StringUtils.isBlank((CharSequence)processo.getUsuarioRegistro())) {
            processo.setUsuarioRegistro(USUARIO_DEFAULT_PROCESSO_EXTERNO);
        }
        processo.setLocalOrigem(this.parametroService.getParamLocalOrigemProcessoExterno(entidade));
        processo.setLocalDestino(this.parametroService.getParamLocalDestinoProcessoExterno(entidade, processo.getAssunto()));
        processo.setBloqueioAnexoExterno(this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_ANEXOS_CONSULTA_EXTERNA_SEM_LIBERACAO_USUARIO_INTERNO.getCodigo(), entidade.getId(), this.exercicioService.getExercicioAtual()));
        return processo;
    }

    @Generated
    public SalvaProcessoExternoStrategy() {
    }

    @Generated
    public SalvaProcessoExternoStrategy(ProtocoloMapper mapper, EntidadeService entidadeService, ParametroService parametroService, PessoaService pessoaService, ExercicioService exercicioService) {
        this.mapper = mapper;
        this.entidadeService = entidadeService;
        this.parametroService = parametroService;
        this.pessoaService = pessoaService;
        this.exercicioService = exercicioService;
    }
}

