/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.strategy.impl.processo;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ORCUnidade;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.ProcessoArquivoService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.strategy.SalvaProcessoStrategy;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalvaProcessoAssinaturaStrategy
implements SalvaProcessoStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SalvaProcessoAssinaturaStrategy.class);
    private ProtocoloMapper mapper;
    private EntidadeService entidadeService;
    private ProcessoArquivoService processoArquivoService;
    private UsuarioService usuarioService;
    private ParametroService parametroService;
    private ExercicioService exercicioService;

    public Processo criar(ProcessoDTO processoDto) {
        Entidade entidade = (Entidade)this.entidadeService.findOne((Serializable)processoDto.getEntidade().getId());
        return this.criarProcesso(processoDto, entidade);
    }

    public Processo criar(ProcessoDTO processoDTO, Long idEntidade) {
        Entidade entidade = (Entidade)this.entidadeService.findOne((Serializable)idEntidade);
        if (Objects.isNull(entidade)) {
            log.error("O par\u00e2metro referente a Entidade do processo assinatura config est\u00e1 incorreto, pois, n\u00e3o encontrou nenhuma entidade com seu valor");
            throw new RegistroNaoEncontradoException("Entidade n\u00e3o localizada, configure corretamente o valor do par\u00e2metro");
        }
        return this.criarProcesso(processoDTO, entidade);
    }

    private Processo criarProcesso(ProcessoDTO processoDto, Entidade entidade) {
        Processo processo = this.mapper.toProcesso(processoDto, new Processo());
        ProcessoPK pkProcesso = ProcessoPK.of((Entidade)entidade, (TipoProcesso)this.mapper.toTipoProcesso(processoDto.getTipo()), null, (Long)Long.valueOf(LocalDate.now().getYear()));
        processo.setId(pkProcesso);
        processo.setExterno(Boolean.FALSE);
        processo.setPossuiTaxa(Boolean.FALSE);
        processo.setUuid(UUID.randomUUID().toString());
        processo.setTipoIntegracaoAssinatura(processoDto.getAssinaturaIntegracao().getTipoIntegracao());
        processo.setIdIntegracaoAssinatura(processoDto.getAssinaturaIntegracao().getIdMovimento());
        processo.setFilaIntegracaoAssinatura(processoDto.getAssinaturaIntegracao().getProcessoFila());
        processo.setBloqueioAnexoExterno(this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_ANEXOS_CONSULTA_EXTERNA_SEM_LIBERACAO_USUARIO_INTERNO.getCodigo(), entidade.getId(), this.exercicioService.getExercicioAtual()));
        if (processo.getUsuarioRegistro() == null) {
            processo.setUsuarioRegistro(processoDto.getAssinaturaIntegracao().getUsuarioSolicitante());
        }
        if (processoDto.getAssinaturaIntegracao().getOrcUnidadeId() != null) {
            processo.setUnidadeOrcamentaria(new ORCUnidade(processoDto.getAssinaturaIntegracao().getOrcUnidadeId()));
        }
        this.processoArquivoService.addProcessoArquivoAssinatura(processo, processoDto.getAssinaturaIntegracao());
        return processo;
    }

    @Generated
    public SalvaProcessoAssinaturaStrategy() {
    }

    @Generated
    public SalvaProcessoAssinaturaStrategy(ProtocoloMapper mapper, EntidadeService entidadeService, ProcessoArquivoService processoArquivoService, UsuarioService usuarioService, ParametroService parametroService, ExercicioService exercicioService) {
        this.mapper = mapper;
        this.entidadeService = entidadeService;
        this.processoArquivoService = processoArquivoService;
        this.usuarioService = usuarioService;
        this.parametroService = parametroService;
        this.exercicioService = exercicioService;
    }
}

