/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.strategy.impl.parametro;

import br.com.elotech.core.common.dto.MailResultInfo;
import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.dto.ResponseParametroValidation;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.strategy.ParametroValidator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.stereotype.Component;

@Component
public class ParametroValidatorSMTP
implements ParametroValidator {
    private final MailService mailService;
    private final ParametroService parametroService;

    public ParametroValidatorSMTP(MailService mailService, ParametroService parametroService) {
        this.mailService = mailService;
        this.parametroService = parametroService;
    }

    public ResponseParametroValidation validar() {
        ResponseParametroValidation responseParametroValidation = new ResponseParametroValidation();
        try {
            MailResultInfo mailResultInfo = this.sendEmailTest();
            responseParametroValidation.setValid(mailResultInfo.isSuccess());
            responseParametroValidation.setMessage(mailResultInfo.getMessage());
        }
        catch (Exception e) {
            responseParametroValidation.setMessage(e.getMessage());
        }
        return responseParametroValidation;
    }

    private MailResultInfo sendEmailTest() throws InterruptedException, ExecutionException, TimeoutException {
        String destinatario = this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_DESTINATARIO_TESTE.getCodigo());
        MailParams mailParams = MailParams.builder().to(destinatario).subject("Teste de configura\u00e7\u00e3o de email.").content("Caso tenha recebido essa mensagem, a conta de e-mail foi configurada com sucesso.").build();
        return (MailResultInfo)this.mailService.sendEmail(mailParams).get(1L, TimeUnit.MINUTES);
    }
}

