/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.strategy;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.LocalDTO;
import br.com.elotech.protocolo.dto.TramiteProcessosWrapper;
import java.util.List;

public abstract class TramiteBusinessStrategy {
    private final Entidade entidade;

    protected TramiteBusinessStrategy(Entidade entidade) {
        this.entidade = entidade;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    protected void throwIfViolation(List<EloViolation> violations, Funcao funcao) {
        String message = String.format("N\u00e3o \u00e9 poss\u00edvel \"%s\" o processo", funcao.getAcao());
        EloValidationException.checkViolations((String)message, violations);
    }

    public abstract void validar(Processo var1, List<EloViolation> var2, LocalDTO var3);

    public abstract Tramite tramitar(Processo var1, TramiteProcessosWrapper var2, String var3);
}

