/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.specs;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.domain.UsuarioLocal;
import br.com.elotech.protocolo.domain.UsuarioTipoProcesso;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.enums.AssinaturaSituacaoEnum;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang3.Range;
import org.springframework.data.jpa.domain.Specification;

public final class ProcessoSpecificationHelper {
    private static final String FIELD_USUARIO = "usuario";
    private static final String FIELD_LOCAL = "local";

    private ProcessoSpecificationHelper() {
    }

    public static Specification<Processo> usuarioPermissaoLocal(Usuario usuario) {
        return (Specification & Serializable)(root, query, cb) -> {
            Subquery subQueryLocal = query.subquery(UsuarioLocal.class);
            Root rootUsuarioLocal = subQueryLocal.from(UsuarioLocal.class);
            Join rootUsuario = rootUsuarioLocal.join("id").join(FIELD_USUARIO);
            Subquery subQueryLocal2 = query.subquery(UsuarioLocal.class);
            Root rootUsuarioLocal2 = subQueryLocal2.from(UsuarioLocal.class);
            Join rootUsuario2 = rootUsuarioLocal2.join("id").join(FIELD_USUARIO);
            Join rootLocal2 = rootUsuarioLocal2.join("id").join(FIELD_LOCAL);
            Subquery subQueryTramite = query.subquery(Tramite.class);
            Root rootTramite = subQueryTramite.from(Tramite.class);
            Join rootTramitelocal = rootTramite.join(FIELD_LOCAL);
            Predicate equalUsuario = cb.equal((Expression)rootUsuario.get("id"), (Object)usuario.getId());
            Predicate equalLocalTramite = cb.equal((Expression)rootTramitelocal.get("id"), (Expression)rootUsuarioLocal.get("id").get(FIELD_LOCAL).get("id"));
            Subquery suqQueryComWhereTramite = subQueryLocal.select((Expression)rootUsuario.get("id")).where(new Predicate[]{equalUsuario, equalLocalTramite});
            Subquery suqQueryComWhereLocalAtual = subQueryLocal2.select((Expression)rootUsuario2.get("id")).where(new Predicate[]{cb.equal((Expression)rootUsuario2.get("id"), (Object)usuario.getId()), cb.equal((Expression)root.get("localDestino"), (Expression)rootLocal2)});
            Predicate predSigiloso = cb.equal((Expression)root.get("sigiloso"), cb.literal((Object)Boolean.TRUE));
            Predicate predAcessos = cb.or((Expression)cb.and((Expression)predSigiloso, (Expression)cb.exists(suqQueryComWhereLocalAtual)), (Expression)cb.and((Expression)cb.not((Expression)predSigiloso), (Expression)cb.exists(suqQueryComWhereTramite)));
            return cb.exists(subQueryTramite.select((Expression)rootTramitelocal.get("id").get("id")).where((Expression)cb.and((Expression)cb.equal((Expression)rootTramite.get("id").get("processo"), (Expression)root), (Expression)predAcessos)));
        };
    }

    public static Specification<Processo> byUsuarioLogado(String cpfCnpj) {
        return (Specification & Serializable)(root, query, cb) -> {
            Join pessoa = root.join("pessoa");
            return cb.equal((Expression)pessoa.get("cnpjCpf"), (Object)cpfCnpj);
        };
    }

    public static Specification<Processo> usuarioPermissaoTramitacaoAtual(Usuario usuario) {
        return (Specification & Serializable)(root, query, cb) -> {
            Subquery subQueryLocal = query.subquery(UsuarioLocal.class);
            Root rootUsuarioLocal = subQueryLocal.from(UsuarioLocal.class);
            Path localDestino = root.get("localDestino");
            Predicate predUsuario = cb.equal((Expression)rootUsuarioLocal.get("id").get(FIELD_USUARIO), (Object)usuario);
            Predicate predLocal = cb.equal((Expression)localDestino, (Expression)rootUsuarioLocal.get("id").get(FIELD_LOCAL));
            Subquery suqQueryComWhere = subQueryLocal.select((Expression)rootUsuarioLocal.get("id").get(FIELD_USUARIO)).where(new Predicate[]{predUsuario, predLocal});
            return cb.exists(suqQueryComWhere);
        };
    }

    public static Specification<Processo> usuarioPermissaoTramitacaoAtualOuLocalAtual(Usuario usuario) {
        return (Specification & Serializable)(root, query, cb) -> {
            Subquery subQueryLocal = query.subquery(UsuarioLocal.class);
            Root rootUsuarioLocal = subQueryLocal.from(UsuarioLocal.class);
            Path localDestino = root.get("localDestino");
            Path localAtual = root.get("localAtual");
            Predicate predUsuario = cb.equal((Expression)rootUsuarioLocal.get("id").get(FIELD_USUARIO), (Object)usuario);
            Predicate predLocal = cb.or((Expression)cb.equal((Expression)localDestino, (Expression)rootUsuarioLocal.get("id").get(FIELD_LOCAL)), (Expression)cb.equal((Expression)localAtual, (Expression)rootUsuarioLocal.get("id").get(FIELD_LOCAL)));
            Subquery suqQueryComWhere = subQueryLocal.select((Expression)rootUsuarioLocal.get("id").get(FIELD_USUARIO)).where(new Predicate[]{predUsuario, predLocal});
            return cb.exists(suqQueryComWhere);
        };
    }

    public static Specification<Processo> filtrarProcessosSemControleDeTramitacao() {
        return (Specification & Serializable)(root, query, cb) -> {
            Path pathAssunto = root.get("assunto").get("controlaTramitacao");
            return cb.or((Expression)cb.isNull((Expression)pathAssunto), (Expression)cb.equal((Expression)pathAssunto, (Object)Boolean.FALSE));
        };
    }

    public static Specification<Processo> usuarioTipoProcesso(Usuario usuario) {
        return (Specification & Serializable)(root, query, cb) -> {
            Subquery subqueryUsuarioTipoProcesso = query.subquery(UsuarioTipoProcesso.class);
            Path tipoProcesso = root.get("id").get("tipo");
            Root rootUsuarioTipoProcesso = subqueryUsuarioTipoProcesso.from(UsuarioTipoProcesso.class);
            Path tipoProcessoUsuario = rootUsuarioTipoProcesso.get("id").get("tipoProcesso");
            Path usuarioExpression = rootUsuarioTipoProcesso.get("id").get(FIELD_USUARIO);
            Subquery subQueryWithWhere = subqueryUsuarioTipoProcesso.select((Expression)usuarioExpression).where(new Predicate[]{cb.equal((Expression)usuarioExpression, (Object)usuario), cb.equal((Expression)tipoProcesso, (Expression)tipoProcessoUsuario)});
            return cb.exists(subQueryWithWhere);
        };
    }

    public static Specification<Processo> byEntidade(Entidade entidadeAtual) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path pathEntidade = root.get("id").get("entidade");
            return cb.equal((Expression)pathEntidade, (Object)entidadeAtual);
        };
    }

    public static Specification<Processo> byIdAssunto(Long idAssunto) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path pathIdAssunto = root.get("assunto").get("id");
            return cb.equal((Expression)pathIdAssunto, (Object)idAssunto);
        };
    }

    public static Specification<Processo> byUsuarioResponsavelTramite(String usuario) {
        return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("usuarioResponsavelTramite").get("id"), (Object)usuario);
    }

    public static Specification<Processo> byUsuarioRegistroTramite(String usuario) {
        return (Specification & Serializable)(root, query, cb) -> {
            Subquery subQueryTramite = query.subquery(Tramite.class);
            Root rootTramite = subQueryTramite.from(Tramite.class);
            return cb.exists(subQueryTramite.select((Expression)rootTramite.get("usuarioRegistro")).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)rootTramite.get("id").get("processo"), (Expression)root), cb.equal((Expression)rootTramite.get("usuarioRegistro"), (Object)usuario), cb.equal((Expression)rootTramite.get("funcao"), (Object)Funcao.ENCAMINHADO)})));
        };
    }

    public static Specification<Processo> byProcessoPago() {
        return (Specification & Serializable)(root, query, cb) -> {
            Path pathIdProcesosTaxa = root.get("idProcessoTaxa");
            Path pathBoletoPago = root.get("boletoPago");
            return cb.or((Expression)cb.isNull((Expression)pathIdProcesosTaxa), (Expression)cb.equal((Expression)pathBoletoPago, (Object)Boolean.TRUE));
        };
    }

    public static Specification<Processo> byFuncoes(Set<Funcao> funcoes) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path funcaoExpression = root.get("funcao");
            return funcaoExpression.in((Collection)funcoes);
        };
    }

    public static Specification<Processo> byAno(Long ano) {
        return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("id").get("ano"), (Object)ano);
    }

    public static Specification<Processo> byTipo(Long tipo) {
        return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("id").get("tipo"), (Object)tipo);
    }

    public static Specification<Processo> byIntervaloNumero(Range<Long> range) {
        return (Specification & Serializable)(root, query, cb) -> cb.between((Expression)root.get("id").get("numero"), (Comparable)((Long)range.getMinimum()), (Comparable)((Long)range.getMaximum()));
    }

    public static Specification<Processo> byLocalDestinoIn(List<Local> locais) {
        return (Specification & Serializable)(root, query, cb) -> root.get("localDestino").in((Collection)locais);
    }

    public static Specification<Processo> byTipoIn(List<TipoProcesso> tipos) {
        return (Specification & Serializable)(root, query, cb) -> root.get("id").get("tipo").in((Collection)tipos);
    }

    public static Specification<Processo> byTramiteLote(Long lote) {
        return (Specification & Serializable)(root, query, cb) -> {
            Subquery subQueryTramite = query.subquery(Tramite.class);
            Root rootTramite = subQueryTramite.from(Tramite.class);
            return cb.exists(subQueryTramite.select((Expression)rootTramite.get("lote")).where((Expression)cb.and((Expression)cb.equal((Expression)rootTramite.get("id").get("processo"), (Expression)root), (Expression)cb.equal((Expression)rootTramite.get("lote"), (Object)lote))));
        };
    }

    public static Specification<Processo> filtrarProcessosUsuarioComAssinatura(String usuario) {
        return (Specification & Serializable)(root, query, cb) -> {
            Subquery subqueryAssinatura = query.subquery(ProcessoArquivoAssinatura.class);
            Root rootAssinatura = subqueryAssinatura.from(ProcessoArquivoAssinatura.class);
            Path rootPk = root.get("id");
            Path subQueryPk = rootAssinatura.get("arquivo").get("id").get("processo").get("id");
            Subquery subqueryProcessosAssinatura = subqueryAssinatura.select((Expression)rootAssinatura).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)rootAssinatura.get(FIELD_USUARIO).get("id"), (Object)usuario), cb.equal((Expression)subQueryPk.get("numero"), (Expression)rootPk.get("numero")), cb.equal((Expression)subQueryPk.get("ano"), (Expression)rootPk.get("ano")), cb.equal((Expression)subQueryPk.get("tipo").get("id"), (Expression)rootPk.get("tipo").get("id")), cb.equal((Expression)subQueryPk.get("entidade").get("id"), (Expression)rootPk.get("entidade").get("id"))}));
            return cb.exists(subqueryProcessosAssinatura);
        };
    }

    public static Specification<Processo> filtrarProcessosAssinaturaPendente() {
        return (Specification & Serializable)(root, query, cb) -> {
            Subquery subqueryAssinatura = query.subquery(Integer.class);
            Root rootAssinatura = subqueryAssinatura.from(ProcessoArquivoAssinatura.class);
            Path rootPk = root.get("id");
            Path subQueryPk = rootAssinatura.get("arquivo").get("id").get("processo").get("id");
            Predicate pendentePredicate = cb.or((Expression)cb.equal((Expression)rootAssinatura.get("situacao"), (Object)AssinaturaSituacaoEnum.PENDENTE), (Expression)cb.and((Expression)rootAssinatura.get("dataAssinatura").isNull(), (Expression)rootAssinatura.get("dataRecusa").isNull()));
            Subquery subqueryProcessosAssinatura = subqueryAssinatura.select(cb.literal((Object)1)).where((Expression)cb.and((Expression)pendentePredicate, (Expression)cb.equal((Expression)subQueryPk, (Expression)rootPk)));
            return cb.exists(subqueryProcessosAssinatura);
        };
    }

    public static Specification<Processo> byParalisado(Boolean paralisado) {
        return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("paralisado"), (Object)paralisado);
    }

    public static Specification<Processo> processoNaoSigiloso() {
        return (Specification & Serializable)(root, query, cb) -> cb.isFalse((Expression)root.get("sigiloso"));
    }
}

