/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.specs;

import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import br.com.elotech.protocolo.enums.AnaliseArquivoEnum;
import br.com.elotech.protocolo.enums.AssinaturaSituacaoEnum;
import br.com.elotech.protocolo.enums.SituacaoArquivoEnum;
import br.com.elotech.protocolo.specs.ProcessoArquivoSpecificationHelper;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.RSQLOperators;
import java.io.Serializable;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ProcessoArquivoSpecificationHelper {
    private ProcessoArquivoSpecificationHelper() {
    }

    private static Predicate getSubquery(Root<ProcessoArquivo> arquivo, CriteriaQuery<?> query, CriteriaBuilder cb, boolean inclusive, AssinaturaSituacaoEnum ... situacoes) {
        Subquery subQuery = query.subquery(Integer.class).select(cb.literal((Object)1));
        Root assinatura = subQuery.from(ProcessoArquivoAssinatura.class);
        Predicate predicate = assinatura.get("situacao").in((Object[])situacoes);
        if (!inclusive) {
            predicate = cb.not((Expression)predicate);
        }
        subQuery.where((Expression)cb.and((Expression)cb.equal((Expression)assinatura.get("arquivo"), arquivo), (Expression)predicate));
        Predicate result = cb.exists(subQuery);
        return inclusive ? result : cb.not((Expression)result);
    }

    private static Predicate getSpecificationFromSituacao(Root<ProcessoArquivo> root, CriteriaQuery<?> query, CriteriaBuilder cb, SituacaoArquivoEnum situacao) {
        Predicate specCancelado = cb.equal((Expression)root.get("cancelado"), cb.literal((Object)true));
        Predicate specRejeitado = cb.equal((Expression)root.get("analise"), cb.literal((Object)AnaliseArquivoEnum.RECUSADO));
        switch (1.$SwitchMap$br$com$elotech$protocolo$enums$SituacaoArquivoEnum[situacao.ordinal()]) {
            case 1: {
                return specCancelado;
            }
            case 2: {
                return cb.isEmpty((Expression)root.get("assinaturas"));
            }
            case 3: {
                return cb.and(new Predicate[]{cb.not((Expression)specCancelado), cb.not((Expression)specRejeitado), ProcessoArquivoSpecificationHelper.getSubquery(root, query, (CriteriaBuilder)cb, (boolean)true, (AssinaturaSituacaoEnum[])new AssinaturaSituacaoEnum[]{AssinaturaSituacaoEnum.PENDENTE, AssinaturaSituacaoEnum.ASSINANDO}), ProcessoArquivoSpecificationHelper.getSubquery(root, query, (CriteriaBuilder)cb, (boolean)true, (AssinaturaSituacaoEnum[])new AssinaturaSituacaoEnum[]{AssinaturaSituacaoEnum.ASSINADO}), ProcessoArquivoSpecificationHelper.getSubquery(root, query, (CriteriaBuilder)cb, (boolean)false, (AssinaturaSituacaoEnum[])new AssinaturaSituacaoEnum[]{AssinaturaSituacaoEnum.ASSINADO, AssinaturaSituacaoEnum.PENDENTE, AssinaturaSituacaoEnum.ASSINANDO})});
            }
            case 4: {
                return cb.and(new Predicate[]{cb.not((Expression)specCancelado), cb.not((Expression)specRejeitado), ProcessoArquivoSpecificationHelper.getSubquery(root, query, (CriteriaBuilder)cb, (boolean)true, (AssinaturaSituacaoEnum[])new AssinaturaSituacaoEnum[]{AssinaturaSituacaoEnum.ASSINADO}), ProcessoArquivoSpecificationHelper.getSubquery(root, query, (CriteriaBuilder)cb, (boolean)false, (AssinaturaSituacaoEnum[])new AssinaturaSituacaoEnum[]{AssinaturaSituacaoEnum.ASSINADO})});
            }
            case 5: {
                return cb.and(new Predicate[]{cb.not((Expression)specCancelado), cb.not((Expression)specRejeitado), ProcessoArquivoSpecificationHelper.getSubquery(root, query, (CriteriaBuilder)cb, (boolean)true, (AssinaturaSituacaoEnum[])new AssinaturaSituacaoEnum[]{AssinaturaSituacaoEnum.PENDENTE, AssinaturaSituacaoEnum.ASSINANDO}), ProcessoArquivoSpecificationHelper.getSubquery(root, query, (CriteriaBuilder)cb, (boolean)false, (AssinaturaSituacaoEnum[])new AssinaturaSituacaoEnum[]{AssinaturaSituacaoEnum.PENDENTE, AssinaturaSituacaoEnum.ASSINANDO})});
            }
            case 6: {
                return cb.and((Expression)cb.not((Expression)specCancelado), (Expression)cb.or((Expression)specRejeitado, (Expression)ProcessoArquivoSpecificationHelper.getSubquery(root, query, (CriteriaBuilder)cb, (boolean)true, (AssinaturaSituacaoEnum[])new AssinaturaSituacaoEnum[]{AssinaturaSituacaoEnum.RECUSADO, AssinaturaSituacaoEnum.REJEITADO})));
            }
        }
        return null;
    }

    public static Specification<ProcessoArquivo> filterSituacao(ComparisonOperator operator, String situacaoStr) {
        if (StringUtils.isBlank((CharSequence)situacaoStr)) {
            return null;
        }
        SituacaoArquivoEnum situacao = SituacaoArquivoEnum.valueOf((String)situacaoStr);
        boolean isPositiveOperator = RSQLOperators.EQUAL.equals((Object)operator);
        return (Specification & Serializable)(root, query, cb) -> {
            Predicate predicate = ProcessoArquivoSpecificationHelper.getSpecificationFromSituacao((Root)root, (CriteriaQuery)query, (CriteriaBuilder)cb, (SituacaoArquivoEnum)situacao);
            return isPositiveOperator ? predicate : cb.not((Expression)predicate);
        };
    }
}

