/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.signer;

import br.com.elotech.protocolo.domain.AssinaturaConfiguracao;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.signer.AssinaturaPosicaoDTO;
import br.com.elotech.protocolo.signer.PdfSigner;
import br.com.elotech.utils.pdf.sign.PdfSignerUtil;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang.WordUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public class PdfSignerOldKind
extends PdfSigner {
    public PdfSignerOldKind(ByteArrayInputStream keyStoreFile, AssinaturaConfiguracao assinaturaConfiguracao, Usuario usuario, ProcessoArquivo processoArquivo) {
        super(keyStoreFile, assinaturaConfiguracao, usuario, processoArquivo);
    }

    protected Rectangle2D getHumanRect(AssinaturaPosicaoDTO assinaturaPosicaoDTO) {
        return this.createSignatureBox(this.getSignatureText(), assinaturaPosicaoDTO.getX(), assinaturaPosicaoDTO.getY());
    }

    protected void setSignatureVisual(PDPageContentStream cs, PDDocument doc, float height, float width, AssinaturaPosicaoDTO assinaturaPosicaoDTO) throws IOException {
        String signatureText = this.getSignatureText();
        float x = doc.getPage(0).getMediaBox().getWidth();
        cs.moveTo(0.0f, 0.0f);
        cs.lineTo(x, 0.0f);
        cs.stroke();
        if (Stream.of(this.getCarimbo(), this.getCarimboNome()).allMatch(Objects::nonNull) && this.getCarimbo().length > 0) {
            cs.saveGraphicsState();
            cs.drawImage(PdfSignerUtil.createFromFileByExtension((String)this.getCarimboNome(), (InputStream)new ByteArrayInputStream(this.getCarimbo()), (PDDocument)doc), 0.0f, 5.0f, 65.0f, 50.0f);
            cs.restoreGraphicsState();
        }
        if (Objects.nonNull(signatureText)) {
            float leading = (float)this.getFontSize().longValue() * 1.5f;
            String[] wrT = WordUtils.wrap((String)signatureText, (int)this.getWrapLength()).split("\\r?\\n");
            cs.beginText();
            cs.setFont(PdfSignerUtil.getFont(Optional.empty()), (float)this.getFontSize().longValue());
            cs.setNonStrokingColor(Color.black);
            cs.newLineAtOffset((float)this.getFontSize().longValue() + 60.0f, height - leading - 20.0f);
            cs.setLeading(leading);
            for (String value : wrT) {
                cs.showText(value);
                cs.newLine();
            }
            cs.endText();
        }
    }

    private int getWrapLength() {
        int font60Size = 8;
        if (this.getFontSize().intValue() == 8) {
            return 60;
        }
        return 50;
    }

    public boolean isNewKind() {
        return false;
    }
}

