/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.signer;

import br.com.elotech.domain.PDFonts;
import br.com.elotech.orcamento.utils.MaskUtils;
import br.com.elotech.protocolo.domain.AssinaturaConfiguracao;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.enums.AssinaturaSituacaoEnum;
import br.com.elotech.protocolo.exception.AssinadorDigitalException;
import br.com.elotech.protocolo.signer.AssinaturaPosicaoDTO;
import br.com.elotech.protocolo.signer.PdfMarginaliaUtils;
import br.com.elotech.protocolo.signer.PdfSigner;
import br.com.elotech.protocolo.utils.PdfUtils;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PdfSignerNewKind
extends PdfSigner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfSignerNewKind.class);
    private static final float BORDA = 5.0f;
    private static final float MARGEM_TEXTO = 2.0f;
    private static final float CURVA = 10.0f;
    private static final float LINHA = 20.0f;
    private static final float ANNOTATION_FONT_SIZE = 8.0f;
    private static final float CONTENT_X = 13.0f;
    private static final float ANNOTATION_X = 37.0f;
    private static final float ALTURA = 50.0f;
    private static final float QR_CODE_SIZE = 40.0f;
    private static final PDFont FONT_CONTENT = PDFonts.HELVETICA.getFont();
    private static final PDFont FONT_ANNOTATION = new PDType1Font(Standard14Fonts.FontName.HELVETICA_BOLD);
    private final String nome;
    private final String cpfCnpj;
    private final String data;
    private final String entidade = this.handleSpaces(RequestHeaderHelper.getEntidadeContextHolder().getNome());

    private String handleSpaces(String text) {
        if (Objects.isNull(text)) {
            return "";
        }
        return text.replaceAll("\\s+", " ").trim();
    }

    public PdfSignerNewKind(ByteArrayInputStream keyStoreFile, AssinaturaConfiguracao assinaturaConfiguracao, Usuario usuario, ProcessoArquivo processoArquivo) {
        super(keyStoreFile, assinaturaConfiguracao, usuario, processoArquivo);
        this.nome = this.handleSpaces(usuario.getNome());
        this.cpfCnpj = Boolean.TRUE.equals(assinaturaConfiguracao.getShowCpf()) ? MaskUtils.formataCnpjCpf((String)usuario.getCpf()) : "";
        this.data = StringUtils.trim((String)String.format("%s %s", Boolean.TRUE.equals(assinaturaConfiguracao.getShowData()) ? LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) : "", Boolean.TRUE.equals(assinaturaConfiguracao.getShowHora()) ? LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss")) : ""));
    }

    protected Rectangle2D getHumanRect(AssinaturaPosicaoDTO assinaturaPosicaoDTO) {
        boolean isUsingQrCodeNaAssinatura = this.getAssinaturaConfiguracao().isUsingQrCodeNaAssinatura();
        float h = 50.0f;
        float contentMaxWidth = Math.max(Math.max(PdfSignerNewKind.getTextWidthFromFont((String)this.entidade), PdfSignerNewKind.getTextWidthFromFont((String)this.nome)), PdfSignerNewKind.getTextWidthFromFont((String)this.cpfCnpj)) * 8.0f + 13.0f;
        float w = Math.max(3.0f * h, contentMaxWidth);
        if (isUsingQrCodeNaAssinatura) {
            w += 45.0f;
            h += 8.0f;
        }
        float x = assinaturaPosicaoDTO.getX().floatValue();
        float y = assinaturaPosicaoDTO.getY().floatValue();
        float r = assinaturaPosicaoDTO.getRatio().floatValue();
        return new Rectangle2D.Float(x, y, w * r, h * r);
    }

    private static float getTextWidthFromFont(String text) throws IOException {
        float width = 0.0f;
        for (String line : text.replace("\r", "").replace("\t", "").split("\n")) {
            width = Math.max(width, FONT_CONTENT.getStringWidth(line));
        }
        return Math.max(width, 1.0f) / 1000.0f;
    }

    protected void setSignatureVisual(PDPageContentStream cs, PDDocument doc, float height, float width, AssinaturaPosicaoDTO assinaturaPosicaoDTO) throws IOException {
        float ratio = assinaturaPosicaoDTO.getRatio().floatValue();
        cs.transform(Matrix.getScaleInstance((float)ratio, (float)ratio));
        boolean isUsingQrCodeNaAssinatura = this.getAssinaturaConfiguracao().isUsingQrCodeNaAssinatura();
        float assinaturaDetalhes = isUsingQrCodeNaAssinatura ? 45.0f : 0.0f;
        PdfSignerNewKind.desenharFundoBranco((PDPageContentStream)cs, (float)(height /= ratio), (float)(width /= ratio));
        PdfSignerNewKind.desenharTextoSuperior((PDPageContentStream)cs, (float)height, (float)assinaturaDetalhes);
        this.desenharTextoInterno(cs, height, assinaturaDetalhes);
        this.desenharTextoInferior(cs, doc, height, assinaturaDetalhes);
        PdfSignerNewKind.desenharContorno((PDPageContentStream)cs, (float)height, (float)assinaturaDetalhes);
        this.desenharQrCode(cs, doc, height, width);
    }

    private static void desenharFundoBranco(PDPageContentStream cs, float height, float width) throws IOException {
        cs.setNonStrokingColor(Color.WHITE);
        cs.addRect(0.0f, 0.0f, width, height);
        cs.fill();
        cs.setNonStrokingColor(Color.BLACK);
    }

    private void desenharQrCode(PDPageContentStream cs, PDDocument doc, float height, float width) throws IOException {
        if (!this.getAssinaturaConfiguracao().isUsingQrCodeNaAssinatura()) {
            return;
        }
        BufferedImage qrImage = PdfUtils.generateQRCodeImage((String)this.getUrlAutenticidade(), (int)Math.round(40.0f));
        PDImageXObject pdImage = LosslessFactory.createFromImage((PDDocument)doc, (BufferedImage)qrImage);
        cs.drawImage(pdImage, 0.0f, height - 5.0f - 40.0f, 40.0f, 40.0f);
        float fontSize = Math.min(width / PdfSignerNewKind.getTextWidthFromFont((String)this.getUrlAutenticidade()) - 1.0f, 8.0f);
        float fontHeight = FONT_ANNOTATION.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * fontSize;
        cs.moveTo(0.0f, 0.0f);
        cs.beginText();
        cs.setFont(FONT_ANNOTATION, fontSize);
        cs.setNonStrokingColor(Color.BLUE);
        cs.newLineAtOffset(0.0f, height - 5.0f - 40.0f - 8.0f - fontHeight);
        cs.showText(this.getUrlAutenticidade());
        for (String decretoLine : this.getAssinaturaConfiguracao().getDecreto().replace("\r", "").split("\n")) {
            cs.newLineAtOffset(0.0f, -fontHeight);
            cs.showText(decretoLine);
        }
        cs.endText();
    }

    private static void desenharTextoSuperior(PDPageContentStream cs, float height, float left) throws IOException {
        cs.moveTo(0.0f, 0.0f);
        cs.beginText();
        cs.setFont(FONT_ANNOTATION, 8.0f);
        cs.newLineAtOffset(left + 37.0f, height - 8.0f);
        cs.showText("Assinado por:");
        cs.endText();
    }

    private void desenharTextoInterno(PDPageContentStream cs, float height, float left) throws IOException {
        float contentLead = -8.0f;
        cs.moveTo(0.0f, 0.0f);
        cs.beginText();
        cs.setFont(FONT_CONTENT, 8.0f);
        cs.newLineAtOffset(left + 13.0f, height - 17.0f);
        cs.showText(this.entidade);
        cs.newLineAtOffset(0.0f, contentLead);
        cs.showText(this.nome);
        cs.newLineAtOffset(0.0f, contentLead);
        cs.showText(this.cpfCnpj);
        cs.endText();
    }

    private void desenharTextoInferior(PDPageContentStream cs, PDDocument doc, float height, float left) throws IOException {
        float x = left + 37.0f;
        if (Objects.nonNull(this.getCarimbo())) {
            PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)doc, (byte[])this.getCarimbo(), (String)this.getCarimboNome());
            float imgH = 16.0f;
            float imgW = imgH * (float)pdImage.getWidth() / (float)pdImage.getHeight();
            cs.drawImage(pdImage, x, height - 50.0f + 5.0f - imgH / 2.0f, imgW, imgH);
            x += imgW + 2.0f;
        }
        cs.moveTo(0.0f, 0.0f);
        cs.beginText();
        cs.setFont(FONT_CONTENT, 8.0f);
        cs.newLineAtOffset(x, height - 46.0f);
        cs.showText(this.data);
        cs.endText();
    }

    private static void desenharContorno(PDPageContentStream cs, float height, float left) throws IOException {
        float top = height - 5.0f;
        float bottom = height - 50.0f + 5.0f;
        float topCurva = top - 10.0f;
        float bottomCurva = bottom + 10.0f;
        float minX = left + 5.0f;
        float maxX = left + 37.0f - 2.0f;
        float leftCurva = minX + 10.0f;
        cs.moveTo(maxX, top);
        cs.lineTo(leftCurva, top);
        cs.curveTo(leftCurva, top, minX, top, minX, topCurva);
        cs.lineTo(minX, bottomCurva);
        cs.curveTo(minX, bottomCurva, minX, bottom, leftCurva, bottom);
        cs.lineTo(maxX, bottom);
        cs.stroke();
    }

    public boolean isNewKind() {
        return true;
    }

    protected File prepareSignature(File inFile) {
        File newInFile = super.prepareSignature(inFile);
        if (!Boolean.TRUE.equals(this.getAssinaturaConfiguracao().getInformacoesNaLateral())) {
            return newInFile;
        }
        try {
            if (this.fileAlreadySigned(newInFile)) {
                return newInFile;
            }
            File tempFile = File.createTempFile(newInFile.getName(), ".pdf");
            PdfMarginaliaUtils.addMarginalia((AssinaturaConfiguracao)this.getAssinaturaConfiguracao(), (ProcessoArquivo)this.getProcessoArquivo(), (File)newInFile, (File)tempFile, (Boolean)Boolean.TRUE);
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (IOException e) {
            throw new AssinadorDigitalException("Falha ao preparar o arquivo para assinatura: " + e.getLocalizedMessage(), (Exception)e);
        }
    }

    private boolean fileAlreadySigned(File newInFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(newInFile);){
            boolean bl = Boolean.TRUE.equals(this.getProcessoArquivo().getPossuiAssinaturaExterna()) || Boolean.TRUE.equals(this.getProcessoArquivo().possuiAssinaturaSituacao(AssinaturaSituacaoEnum.ASSINADO)) || PdfUtils.pdfHasSignatures((byte[])fis.readAllBytes());
            return bl;
        }
    }
}

